/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.context.env.Environment;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.function.aws.HandlerUtils;
import io.micronaut.function.aws.LambdaApplicationContextBuilder;
import io.micronaut.function.aws.MicronautLambdaContext;
import io.micronaut.function.aws.event.AfterExecutionEvent;
import io.micronaut.function.executor.StreamFunctionExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicronautRequestStreamHandler
extends StreamFunctionExecutor<Context>
implements RequestStreamHandler,
MicronautLambdaContext {
    private static final Logger LOG = LoggerFactory.getLogger(MicronautRequestStreamHandler.class);
    private ApplicationEventPublisher<AfterExecutionEvent> eventPublisher;
    @Nullable
    private String ctxFunctionName;

    public MicronautRequestStreamHandler() {
        try {
            this.buildApplicationContext(null);
        }
        catch (Exception e) {
            LOG.error("Exception initializing handler: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public MicronautRequestStreamHandler(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        if (context != null) {
            this.ctxFunctionName = context.getFunctionName();
        }
        HandlerUtils.configureWithContext((ApplicationContextProvider)this, context);
        try {
            this.execute(input, output, context);
            this.resolveAfterExecutionPublisher().publishEvent((Object)AfterExecutionEvent.success(context, null));
        }
        catch (Throwable e) {
            this.resolveAfterExecutionPublisher().publishEvent((Object)AfterExecutionEvent.failure(context, e));
            throw e;
        }
    }

    protected ApplicationContext buildApplicationContext(Context context) {
        return super.buildApplicationContext((Object)context);
    }

    @NonNull
    protected ApplicationContextBuilder newApplicationContextBuilder() {
        return new LambdaApplicationContextBuilder();
    }

    protected String resolveFunctionName(Environment env) {
        String functionName = super.resolveFunctionName(env);
        return functionName != null ? functionName : this.ctxFunctionName;
    }

    private ApplicationEventPublisher<AfterExecutionEvent> resolveAfterExecutionPublisher() {
        if (this.eventPublisher == null) {
            this.eventPublisher = this.applicationContext.getEventPublisher(AfterExecutionEvent.class);
        }
        return this.eventPublisher;
    }

    public void close() {
    }
}

