/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws;

import com.amazonaws.services.lambda.runtime.CustomPojoSerializer;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.type.Argument;
import io.micronaut.function.aws.CustomPojoSerializerException;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.JsonMapperSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ServiceLoader;
import java.util.stream.Stream;

public class JsonMapperCustomPojoSerializer
implements CustomPojoSerializer {
    private JsonMapper jsonMapper = this.createDefault();

    @NonNull
    private JsonMapper createDefault() {
        return (JsonMapper)ServiceLoader.load(JsonMapperSupplier.class).stream().flatMap(p -> {
            try {
                JsonMapperSupplier supplier = (JsonMapperSupplier)p.get();
                return Stream.ofNullable(supplier);
            }
            catch (Exception e) {
                return Stream.empty();
            }
        }).sorted(OrderUtil.COMPARATOR).flatMap(jsonMapperSupplier -> {
            try {
                return Stream.of((JsonMapper)jsonMapperSupplier.get());
            }
            catch (Exception e) {
                return Stream.empty();
            }
        }).findFirst().orElseThrow(() -> new IllegalStateException("No JsonMapper implementation found"));
    }

    public <T> T fromJson(InputStream input, Type type) {
        try {
            return (T)this.jsonMapper.readValue(input, Argument.of((Type)type));
        }
        catch (IOException e) {
            throw new CustomPojoSerializerException(e);
        }
    }

    public <T> T fromJson(String input, Type type) {
        try {
            return (T)this.jsonMapper.readValue(input, Argument.of((Type)type));
        }
        catch (IOException e) {
            throw new CustomPojoSerializerException(e);
        }
    }

    public <T> void toJson(T value, OutputStream output, Type type) {
        Argument argumentType = Argument.of((Type)type);
        try {
            this.jsonMapper.writeValue(output, argumentType, value);
        }
        catch (IOException e) {
            throw new CustomPojoSerializerException(e);
        }
    }
}

