/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import java.util.Optional;

public final class XRayUtils {
    public static final String LAMBDA_TRACE_HEADER_PROP = "com.amazonaws.xray.traceHeader";
    private static final String ENV_X_AMZN_TRACE_ID = "_X_AMZN_TRACE_ID";

    private XRayUtils() {
    }

    @NonNull
    public static Optional<String> parseXrayTraceId() {
        String[] arr;
        String lambdaTraceHeaderKey = System.getenv(ENV_X_AMZN_TRACE_ID);
        String string = lambdaTraceHeaderKey = StringUtils.isNotEmpty((CharSequence)lambdaTraceHeaderKey) ? lambdaTraceHeaderKey : System.getProperty(LAMBDA_TRACE_HEADER_PROP);
        if (lambdaTraceHeaderKey != null && (arr = lambdaTraceHeaderKey.split(";")).length >= 1) {
            return Optional.of(arr[0].replace("Root=", ""));
        }
        return Optional.empty();
    }
}

