/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.aws;

import com.amazonaws.services.lambda.runtime.Context;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.function.aws.DiagnosticInfoPopulator;
import io.micronaut.function.aws.XRayUtils;
import jakarta.inject.Singleton;
import org.slf4j.MDC;

@Singleton
public class DefaultDiagnosticInfoPopulator
implements DiagnosticInfoPopulator {
    public static final String MDC_DEFAULT_AWS_REQUEST_ID = "AWSRequestId";
    public static final String MDC_DEFAULT_FUNCTION_NAME = "AWSFunctionName";
    public static final String MDC_DEFAULT_FUNCTION_VERSION = "AWSFunctionVersion";
    public static final String MDC_DEFAULT_FUNCTION_ARN = "AWSFunctionArn";
    public static final String MDC_DEFAULT_FUNCTION_MEMORY_SIZE = "AWSFunctionMemoryLimit";
    public static final String MDC_DEFAULT_FUNCTION_REMAINING_TIME = "AWSFunctionRemainingTime";
    public static final String MDC_DEFAULT_XRAY_TRACE_ID = "AWS-XRAY-TRACE-ID";

    @Override
    public void populateMappingDiagnosticContextValues(@NonNull Context context) {
        if (context.getAwsRequestId() != null) {
            this.mdcput(MDC_DEFAULT_AWS_REQUEST_ID, context.getAwsRequestId());
        }
        if (context.getFunctionName() != null) {
            this.mdcput(MDC_DEFAULT_FUNCTION_NAME, context.getFunctionName());
        }
        if (context.getFunctionVersion() != null) {
            this.mdcput(MDC_DEFAULT_FUNCTION_VERSION, context.getFunctionVersion());
        }
        if (context.getInvokedFunctionArn() != null) {
            this.mdcput(MDC_DEFAULT_FUNCTION_ARN, context.getInvokedFunctionArn());
        }
        this.mdcput(MDC_DEFAULT_FUNCTION_MEMORY_SIZE, String.valueOf(context.getMemoryLimitInMB()));
        this.mdcput(MDC_DEFAULT_FUNCTION_REMAINING_TIME, String.valueOf(context.getRemainingTimeInMillis()));
    }

    protected void mdcput(@NonNull String key, @NonNull String val) throws IllegalArgumentException {
        MDC.put((String)key, (String)val);
    }

    @Override
    public void populateMappingDiagnosticContextWithXrayTraceId() {
        XRayUtils.parseXrayTraceId().ifPresent(xrayTraceId -> this.mdcput(MDC_DEFAULT_XRAY_TRACE_ID, (String)xrayTraceId));
    }
}

