/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.cosmos.client;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosClient;
import io.micronaut.azure.cosmos.client.CosmosClientConfiguration;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import jakarta.inject.Singleton;

@Factory
@Internal
final class CosmosClientFactory {
    CosmosClientFactory() {
    }

    @Bean(preDestroy="close")
    @Singleton
    @Requires(beans={CosmosClientConfiguration.class})
    CosmosClient buildCosmosClient(CosmosClientConfiguration configuration) {
        return configuration.getCosmosClientBuilder().buildClient();
    }

    @Bean(preDestroy="close")
    @Singleton
    @Requires(beans={CosmosClientConfiguration.class})
    CosmosAsyncClient buildCosmosAsyncClient(CosmosClientConfiguration configuration) {
        return configuration.getCosmosClientBuilder().buildAsyncClient();
    }
}

