/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.cosmos.client;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosClientBuilder;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.NonNull;

@ConfigurationProperties(value="azure.cosmos")
public final class CosmosClientConfiguration {
    static final String PREFIX = "azure.cosmos";
    private static final ConsistencyLevel DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.EVENTUAL;
    private static final boolean DEFAULT_ENDPOINT_DISCOVERY = true;
    @ConfigurationBuilder(prefixes={""})
    protected CosmosClientBuilder cosmosClientBuilder = new CosmosClientBuilder();
    private boolean defaultGatewayMode;
    private boolean endpointDiscoveryEnabled = true;
    private ConsistencyLevel consistencyLevel = DEFAULT_CONSISTENCY_LEVEL;

    @NonNull
    public CosmosClientBuilder getCosmosClientBuilder() {
        if (this.defaultGatewayMode) {
            this.cosmosClientBuilder.gatewayMode();
        }
        return this.cosmosClientBuilder.endpointDiscoveryEnabled(this.endpointDiscoveryEnabled).consistencyLevel(this.consistencyLevel);
    }

    public void setDefaultGatewayMode(boolean defaultGatewayMode) {
        this.defaultGatewayMode = defaultGatewayMode;
    }

    public void setEndpointDiscoveryEnabled(boolean endpointDiscoveryEnabled) {
        this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
    }

    public void setConsistencyLevel(@NonNull ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }
}

