/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http.test;

import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import com.microsoft.azure.functions.HttpStatusType;
import io.micronaut.azure.function.http.AzureFunctionHttpRequest;
import io.micronaut.azure.function.http.AzureFunctionHttpResponse;
import io.micronaut.azure.function.http.HttpRequestMessageBuilder;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.IOUtils;
import io.micronaut.function.BinaryTypeConfiguration;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.exceptions.HttpServerException;
import io.micronaut.http.server.exceptions.ServerStartupException;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.servlet.http.BodyBuilder;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpHandler;
import io.micronaut.servlet.http.ServletHttpResponse;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;

@Singleton
@Internal
final class AzureFunctionEmbeddedServer
implements EmbeddedServer {
    private final ApplicationContext applicationContext;
    private final ServerPort serverPort;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Server server;

    AzureFunctionEmbeddedServer(ApplicationContext applicationContext, HttpServerConfiguration httpServerConfiguration) {
        this.applicationContext = applicationContext;
        this.serverPort = this.createServerPort(httpServerConfiguration);
    }

    private ServerPort createServerPort(HttpServerConfiguration httpServerConfiguration) {
        Optional portOpt = httpServerConfiguration.getPort();
        if (portOpt.isPresent()) {
            Integer port = (Integer)portOpt.get();
            if (port == -1) {
                return new ServerPort(true, 0);
            }
            return new ServerPort(false, port);
        }
        if (this.applicationContext.getEnvironment().getActiveNames().contains("test")) {
            return new ServerPort(true, 0);
        }
        return new ServerPort(false, 8080);
    }

    public EmbeddedServer start() {
        if (this.running.compareAndSet(false, true)) {
            int port = this.serverPort.port();
            try {
                this.server = new Server(port);
                this.server.setHandler((Handler)new AzureHandler(this.applicationContext, this.applicationContext.getConversionService()));
                this.server.start();
            }
            catch (Exception e) {
                throw new ServerStartupException(e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    public EmbeddedServer stop() {
        if (this.running.compareAndSet(true, false)) {
            try {
                this.applicationContext.stop();
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public int getPort() {
        return this.server.getURI().getPort();
    }

    public String getHost() {
        return "localhost";
    }

    public String getScheme() {
        return "http";
    }

    public URL getURL() {
        String spec = this.getScheme() + "://" + this.getHost() + ":" + this.getPort();
        try {
            return new URL(spec);
        }
        catch (MalformedURLException e) {
            throw new HttpServerException("Invalid server URL " + spec);
        }
    }

    public URI getURI() {
        try {
            return this.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new HttpServerException("Invalid server URL " + this.getURL());
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return (ApplicationConfiguration)this.applicationContext.getBean(ApplicationConfiguration.class);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    private record ServerPort(boolean random, Integer port) {
    }

    private static final class AzureHandler
    extends AbstractHandler {
        private final ServletHttpHandler<HttpRequestMessage<Optional<String>>, HttpResponseMessage> httpHandler;

        AzureHandler(ApplicationContext applicationContext, ConversionService conversionService) {
            this.httpHandler = new ServletHttpHandler<HttpRequestMessage<Optional<String>>, HttpResponseMessage>(applicationContext, conversionService){

                public boolean isRunning() {
                    return this.applicationContext.isRunning();
                }

                protected ServletExchange<HttpRequestMessage<Optional<String>>, HttpResponseMessage> createExchange(HttpRequestMessage<Optional<String>> request, HttpResponseMessage response) {
                    throw new UnsupportedOperationException("Creating the exchange directly is not supported");
                }
            };
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            HttpRequestMessageBuilder requestMessageBuilder = HttpRequestMessageBuilder.builder((com.microsoft.azure.functions.HttpMethod)com.microsoft.azure.functions.HttpMethod.value((String)request.getMethod()), (String)baseRequest.getOriginalURI(), (ApplicationContext)this.httpHandler.getApplicationContext());
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String s = (String)headerNames.nextElement();
                Enumeration headers = request.getHeaders(s);
                while (headers.hasMoreElements()) {
                    String v = (String)headers.nextElement();
                    requestMessageBuilder.header(s, v);
                }
            }
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String s = (String)parameterNames.nextElement();
                CharSequence[] parameterValues = request.getParameterValues(s);
                requestMessageBuilder.parameter(s, String.join((CharSequence)",", parameterValues));
            }
            HttpMethod httpMethod = HttpMethod.parse((String)request.getMethod());
            if (HttpMethod.permitsRequestBody((HttpMethod)httpMethod)) {
                try (ServletInputStream inputStream2 = request.getInputStream();
                     InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream2);
                     BufferedReader requestBody = new BufferedReader(inputStreamReader);){
                    String body = IOUtils.readText((BufferedReader)requestBody);
                    requestMessageBuilder.body((Object)body);
                }
                catch (IOException inputStream2) {
                    // empty catch block
                }
            }
            HttpRequestMessage requestMessage = requestMessageBuilder.buildEncoded();
            ConversionService handlerConversionService = (ConversionService)this.httpHandler.getApplicationContext().getBean(ConversionService.class);
            BinaryTypeConfiguration binaryTypeConfiguration = (BinaryTypeConfiguration)this.httpHandler.getApplicationContext().getBean(BinaryTypeConfiguration.class);
            AzureFunctionHttpRequest azureFunctionHttpRequest = new AzureFunctionHttpRequest(requestMessage, new AzureFunctionHttpResponse(requestMessage, handlerConversionService, binaryTypeConfiguration), (ExecutionContext)new DefaultExecutionContext(), handlerConversionService, binaryTypeConfiguration, (BodyBuilder)this.httpHandler.getApplicationContext().getBean(BodyBuilder.class));
            ServletExchange exchange = this.httpHandler.exchange((ServletExchange)azureFunctionHttpRequest);
            ServletHttpResponse exchangeResponse = exchange.getResponse();
            HttpResponseMessage httpResponseMessage = (HttpResponseMessage)exchangeResponse.getNativeResponse();
            HttpStatusType httpStatus = httpResponseMessage.getStatus();
            Object bodyObject = httpResponseMessage.getBody();
            byte[] bodyAsBytes = null;
            if (bodyObject instanceof CharSequence) {
                CharSequence charBody = (CharSequence)bodyObject;
                bodyAsBytes = charBody.toString().getBytes(exchangeResponse.getCharacterEncoding());
            } else if (bodyObject instanceof byte[]) {
                byte[] byteBody;
                bodyAsBytes = byteBody = (byte[])bodyObject;
            }
            response.setStatus(httpStatus.value());
            boolean hasBody = bodyAsBytes != null;
            response.setContentLength(hasBody ? bodyAsBytes.length : 0);
            if (httpResponseMessage instanceof HttpHeaders) {
                HttpHeaders headers = (HttpHeaders)httpResponseMessage;
                headers.forEach((name, values) -> {
                    for (String value : values) {
                        if (response.containsHeader(name)) continue;
                        response.addHeader(name, value);
                    }
                });
            }
            if (hasBody && bodyAsBytes.length > 0) {
                try (ServletOutputStream responseBody = response.getOutputStream();){
                    responseBody.write(bodyAsBytes);
                    responseBody.flush();
                }
            } else {
                response.flushBuffer();
            }
        }
    }

    private static class DefaultExecutionContext
    implements ExecutionContext {
        private DefaultExecutionContext() {
        }

        public Logger getLogger() {
            return LogManager.getLogManager().getLogger(AzureFunctionEmbeddedServer.class.getName());
        }

        public String getInvocationId() {
            return this.getFunctionName();
        }

        public String getFunctionName() {
            return "io.micronaut.azure.function.http.AzureHttpFunction";
        }
    }
}

