/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.TraceContext;
import io.micronaut.azure.function.http.AzureFunctionHttpRequest;
import io.micronaut.azure.function.http.AzureServletBodyBinder;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.servlet.http.ServletBinderRegistry;
import io.micronaut.servlet.http.ServletBodyBinder;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;

@Singleton
@Replaces(value=DefaultRequestBinderRegistry.class)
@Internal
public class AzureBinderRegistry
extends ServletBinderRegistry {
    private static final Argument<ExecutionContext> EXECUTION_CONTEXT_ARGUMENT = Argument.of(ExecutionContext.class);
    private static final Argument<TraceContext> TRACE_CONTEXT_ARGUMENT = Argument.of(TraceContext.class);
    private static final Argument<Logger> LOGGER_ARGUMENT = Argument.of(Logger.class);
    private static final Argument<HttpRequestMessage> REQUEST_MESSAGE_ARGUMENT = Argument.of(HttpRequestMessage.class);

    AzureBinderRegistry(MediaTypeCodecRegistry mediaTypeCodecRegistry, ConversionService conversionService, List<RequestArgumentBinder> binders) {
        super(mediaTypeCodecRegistry, conversionService, binders);
        this.byType.put(HttpRequestMessage.class, new TypedRequestArgumentBinder<HttpRequestMessage>(){

            public ArgumentBinder.BindingResult<HttpRequestMessage> bind(ArgumentConversionContext<HttpRequestMessage> context, HttpRequest<?> source) {
                if (source instanceof AzureFunctionHttpRequest) {
                    return () -> Optional.of(((AzureFunctionHttpRequest)source).getNativeRequest());
                }
                return ArgumentBinder.BindingResult.EMPTY;
            }

            public Argument<HttpRequestMessage> argumentType() {
                return REQUEST_MESSAGE_ARGUMENT;
            }
        });
        this.byType.put(ExecutionContext.class, new TypedRequestArgumentBinder<ExecutionContext>(){

            public ArgumentBinder.BindingResult<ExecutionContext> bind(ArgumentConversionContext<ExecutionContext> context, HttpRequest<?> source) {
                if (source instanceof AzureFunctionHttpRequest) {
                    return () -> Optional.of(((AzureFunctionHttpRequest)source).getExecutionContext());
                }
                return ArgumentBinder.BindingResult.EMPTY;
            }

            public Argument<ExecutionContext> argumentType() {
                return EXECUTION_CONTEXT_ARGUMENT;
            }
        });
        this.byType.put(Logger.class, new TypedRequestArgumentBinder<Logger>(){

            public ArgumentBinder.BindingResult<Logger> bind(ArgumentConversionContext<Logger> context, HttpRequest<?> source) {
                if (source instanceof AzureFunctionHttpRequest) {
                    return () -> Optional.of(((AzureFunctionHttpRequest)source).getExecutionContext().getLogger());
                }
                return ArgumentBinder.BindingResult.EMPTY;
            }

            public Argument<Logger> argumentType() {
                return LOGGER_ARGUMENT;
            }
        });
        this.byType.put(TraceContext.class, new TypedRequestArgumentBinder<TraceContext>(){

            public ArgumentBinder.BindingResult<TraceContext> bind(ArgumentConversionContext<TraceContext> context, HttpRequest<?> source) {
                if (source instanceof AzureFunctionHttpRequest) {
                    return () -> Optional.ofNullable(((AzureFunctionHttpRequest)source).getExecutionContext().getTraceContext());
                }
                return ArgumentBinder.BindingResult.EMPTY;
            }

            public Argument<TraceContext> argumentType() {
                return TRACE_CONTEXT_ARGUMENT;
            }
        });
    }

    protected ServletBodyBinder<?> newServletBodyBinder(MediaTypeCodecRegistry mediaTypeCodecRegistry, ConversionService conversionService) {
        return new AzureServletBodyBinder(conversionService, mediaTypeCodecRegistry);
    }
}

