/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import io.micronaut.azure.function.http.AzureFunctionHttpResponse;
import io.micronaut.azure.function.http.AzureMutableHeaders;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.simple.cookies.SimpleCookies;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpRequest;
import io.micronaut.servlet.http.ServletHttpResponse;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Internal
public class AzureFunctionHttpRequest<B>
implements ServletHttpRequest<HttpRequestMessage<Optional<String>>, B>,
ServletExchange<HttpRequestMessage<Optional<String>>, HttpResponseMessage> {
    private static final Map<String, String> UPPERCASE_HEADER_TO_HEADER;
    private final HttpRequestMessage<Optional<String>> azureRequest;
    private final URI uri;
    private final HttpMethod method;
    private final AzureMutableHeaders headers;
    private final MediaTypeCodecRegistry codecRegistry;
    private final AzureFunctionHttpResponse<?> azureResponse;
    private final ExecutionContext executionContext;
    private HttpParameters httpParameters;
    private MutableConvertibleValues<Object> attributes;
    private Object body;
    private Cookies cookies;

    public AzureFunctionHttpRequest(String contextPath, HttpRequestMessage<Optional<String>> azureRequest, MediaTypeCodecRegistry codecRegistry, ExecutionContext executionContext) {
        HttpMethod method;
        this.executionContext = executionContext;
        this.azureRequest = azureRequest;
        this.azureResponse = new AzureFunctionHttpResponse(azureRequest, codecRegistry);
        this.uri = azureRequest.getUri();
        try {
            method = HttpMethod.valueOf((String)azureRequest.getHttpMethod().name());
        }
        catch (IllegalArgumentException e) {
            method = HttpMethod.CUSTOM;
        }
        this.method = method;
        this.headers = new AzureMutableHeaders(this.toMultiValueMap(azureRequest.getHeaders()), ConversionService.SHARED);
        this.codecRegistry = codecRegistry;
    }

    @NonNull
    private static String normalizeHeaderName(@NonNull String headerName) {
        return UPPERCASE_HEADER_TO_HEADER.getOrDefault(headerName.toUpperCase(Locale.ENGLISH), headerName);
    }

    private Map<CharSequence, List<String>> toMultiValueMap(Map<String, String> headers) {
        LinkedHashMap<CharSequence, List<String>> result = new LinkedHashMap<CharSequence, List<String>>(headers.size());
        headers.forEach((key, value) -> {
            ArrayList<String> values = new ArrayList<String>(1);
            values.add((String)value);
            result.put(AzureFunctionHttpRequest.normalizeHeaderName(key), values);
        });
        return result;
    }

    public String getMethodName() {
        return this.azureRequest.getHttpMethod().name();
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(((Optional)this.azureRequest.getBody()).map(s -> s.getBytes(this.getCharacterEncoding())).orElseThrow(() -> new IOException("Empty Body")));
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader(this.getInputStream(), this.getCharacterEncoding()));
    }

    public HttpRequestMessage<Optional<String>> getNativeRequest() {
        return this.azureRequest;
    }

    AzureFunctionHttpResponse<?> getAzureResponse() {
        return this.azureResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Cookies getCookies() {
        Cookies cookies = this.cookies;
        if (cookies == null) {
            AzureFunctionHttpRequest azureFunctionHttpRequest = this;
            synchronized (azureFunctionHttpRequest) {
                cookies = this.cookies;
                if (cookies == null) {
                    this.cookies = cookies = new SimpleCookies(ConversionService.SHARED);
                }
            }
        }
        return cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public HttpParameters getParameters() {
        HttpParameters httpParameters = this.httpParameters;
        if (httpParameters == null) {
            AzureFunctionHttpRequest azureFunctionHttpRequest = this;
            synchronized (azureFunctionHttpRequest) {
                httpParameters = this.httpParameters;
                if (httpParameters == null) {
                    this.httpParameters = httpParameters = new AzureParameters();
                }
            }
        }
        return httpParameters;
    }

    @NonNull
    public HttpMethod getMethod() {
        return this.method;
    }

    @NonNull
    public URI getUri() {
        return this.uri;
    }

    @NonNull
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap attributes = this.attributes;
        if (attributes == null) {
            AzureFunctionHttpRequest azureFunctionHttpRequest = this;
            synchronized (azureFunctionHttpRequest) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap();
                }
            }
        }
        return attributes;
    }

    @NonNull
    public Optional<B> getBody() {
        return this.getBody(Argument.OBJECT_ARGUMENT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public <T> Optional<T> getBody(@NonNull Argument<T> arg) {
        if (arg == null) return Optional.empty();
        Class type = arg.getType();
        MediaType contentType = this.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        if (this.body == null) {
            if (this.isFormSubmission(contentType)) {
                this.body = this.getParameters();
                if (ConvertibleValues.class == type) return Optional.of(this.body);
                if (Object.class != type) return Optional.empty();
                return Optional.of(this.body);
            }
            MediaTypeCodec codec = this.codecRegistry.findCodec(contentType, type).orElse(null);
            if (codec == null) return Optional.empty();
            try (InputStream inputStream = this.getInputStream();){
                Object value;
                if (ConvertibleValues.class == type) {
                    Map map = (Map)codec.decode(Map.class, inputStream);
                    this.body = ConvertibleValues.of((Map)map);
                    Optional<Object> optional2 = Optional.of(this.body);
                    return optional2;
                }
                this.body = value = codec.decode(arg, inputStream);
                Optional<Object> optional = Optional.ofNullable(value);
                return optional;
            }
            catch (IOException e) {
                throw new CodecException("Error decoding request body: " + e.getMessage(), (Throwable)e);
            }
        }
        if (type.isInstance(this.body)) {
            return Optional.of(this.body);
        }
        if (this.body == this.httpParameters) return Optional.empty();
        Object result = ConversionService.SHARED.convertRequired(this.body, arg);
        return Optional.ofNullable(result);
    }

    private boolean isFormSubmission(MediaType contentType) {
        return MediaType.FORM.equals((Object)contentType) || MediaType.MULTIPART_FORM_DATA_TYPE.equals((Object)contentType);
    }

    public ServletHttpRequest<HttpRequestMessage<Optional<String>>, ? super Object> getRequest() {
        return this;
    }

    public ServletHttpResponse<HttpResponseMessage, ? super Object> getResponse() {
        return this.azureResponse;
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("Accept".toUpperCase(Locale.ENGLISH), "Accept");
        m.put("Accept".toUpperCase(Locale.ENGLISH), "Accept");
        m.put("Accept-CH".toUpperCase(Locale.ENGLISH), "Accept-CH");
        m.put("Accept-CH-Lifetime".toUpperCase(Locale.ENGLISH), "Accept-CH-Lifetime");
        m.put("Accept-Charset".toUpperCase(Locale.ENGLISH), "Accept-Charset");
        m.put("Accept-Encoding".toUpperCase(Locale.ENGLISH), "Accept-Encoding");
        m.put("Accept-Language".toUpperCase(Locale.ENGLISH), "Accept-Language");
        m.put("Accept-Ranges".toUpperCase(Locale.ENGLISH), "Accept-Ranges");
        m.put("Accept-Patch".toUpperCase(Locale.ENGLISH), "Accept-Patch");
        m.put("Access-Control-Allow-Credentials".toUpperCase(Locale.ENGLISH), "Access-Control-Allow-Credentials");
        m.put("Access-Control-Allow-Headers".toUpperCase(Locale.ENGLISH), "Access-Control-Allow-Headers");
        m.put("Access-Control-Allow-Methods".toUpperCase(Locale.ENGLISH), "Access-Control-Allow-Methods");
        m.put("Access-Control-Allow-Origin".toUpperCase(Locale.ENGLISH), "Access-Control-Allow-Origin");
        m.put("Access-Control-Expose-Headers".toUpperCase(Locale.ENGLISH), "Access-Control-Expose-Headers");
        m.put("Access-Control-Max-Age".toUpperCase(Locale.ENGLISH), "Access-Control-Max-Age");
        m.put("Access-Control-Request-Headers".toUpperCase(Locale.ENGLISH), "Access-Control-Request-Headers");
        m.put("Access-Control-Request-Method".toUpperCase(Locale.ENGLISH), "Access-Control-Request-Method");
        m.put("Age".toUpperCase(Locale.ENGLISH), "Age");
        m.put("Allow".toUpperCase(Locale.ENGLISH), "Allow");
        m.put("Authorization".toUpperCase(Locale.ENGLISH), "Authorization");
        m.put("Authorization-Info".toUpperCase(Locale.ENGLISH), "Authorization-Info");
        m.put("Cache-Control".toUpperCase(Locale.ENGLISH), "Cache-Control");
        m.put("Connection".toUpperCase(Locale.ENGLISH), "Connection");
        m.put("Content-Base".toUpperCase(Locale.ENGLISH), "Content-Base");
        m.put("Content-Disposition".toUpperCase(Locale.ENGLISH), "Content-Disposition");
        m.put("Content-DPR".toUpperCase(Locale.ENGLISH), "Content-DPR");
        m.put("Content-Encoding".toUpperCase(Locale.ENGLISH), "Content-Encoding");
        m.put("Content-Language".toUpperCase(Locale.ENGLISH), "Content-Language");
        m.put("Content-Length".toUpperCase(Locale.ENGLISH), "Content-Length");
        m.put("Content-Location".toUpperCase(Locale.ENGLISH), "Content-Location");
        m.put("Content-Transfer-Encoding".toUpperCase(Locale.ENGLISH), "Content-Transfer-Encoding");
        m.put("Content-MD5".toUpperCase(Locale.ENGLISH), "Content-MD5");
        m.put("Content-Range".toUpperCase(Locale.ENGLISH), "Content-Range");
        m.put("Content-Type".toUpperCase(Locale.ENGLISH), "Content-Type");
        m.put("Cookie".toUpperCase(Locale.ENGLISH), "Cookie");
        m.put("Cross-Origin-Resource-Policy".toUpperCase(Locale.ENGLISH), "Cross-Origin-Resource-Policy");
        m.put("Date".toUpperCase(Locale.ENGLISH), "Date");
        m.put("Device-Memory".toUpperCase(Locale.ENGLISH), "Device-Memory");
        m.put("Downlink".toUpperCase(Locale.ENGLISH), "Downlink");
        m.put("DPR".toUpperCase(Locale.ENGLISH), "DPR");
        m.put("ECT".toUpperCase(Locale.ENGLISH), "ECT");
        m.put("ETag".toUpperCase(Locale.ENGLISH), "ETag");
        m.put("Expect".toUpperCase(Locale.ENGLISH), "Expect");
        m.put("Expires".toUpperCase(Locale.ENGLISH), "Expires");
        m.put("Feature-Policy".toUpperCase(Locale.ENGLISH), "Feature-Policy");
        m.put("Forwarded".toUpperCase(Locale.ENGLISH), "Forwarded");
        m.put("From".toUpperCase(Locale.ENGLISH), "From");
        m.put("Host".toUpperCase(Locale.ENGLISH), "Host");
        m.put("If-Match".toUpperCase(Locale.ENGLISH), "If-Match");
        m.put("If-Modified-Since".toUpperCase(Locale.ENGLISH), "If-Modified-Since");
        m.put("If-None-Match".toUpperCase(Locale.ENGLISH), "If-None-Match");
        m.put("If-Range".toUpperCase(Locale.ENGLISH), "If-Range");
        m.put("If-Unmodified-Since".toUpperCase(Locale.ENGLISH), "If-Unmodified-Since");
        m.put("Last-Modified".toUpperCase(Locale.ENGLISH), "Last-Modified");
        m.put("Link".toUpperCase(Locale.ENGLISH), "Link");
        m.put("Location".toUpperCase(Locale.ENGLISH), "Location");
        m.put("Max-Forwards".toUpperCase(Locale.ENGLISH), "Max-Forwards");
        m.put("Origin".toUpperCase(Locale.ENGLISH), "Origin");
        m.put("Pragma".toUpperCase(Locale.ENGLISH), "Pragma");
        m.put("Proxy-Authenticate".toUpperCase(Locale.ENGLISH), "Proxy-Authenticate");
        m.put("Proxy-Authorization".toUpperCase(Locale.ENGLISH), "Proxy-Authorization");
        m.put("Range".toUpperCase(Locale.ENGLISH), "Range");
        m.put("Referer".toUpperCase(Locale.ENGLISH), "Referer");
        m.put("Referrer-Policy".toUpperCase(Locale.ENGLISH), "Referrer-Policy");
        m.put("Retry-After".toUpperCase(Locale.ENGLISH), "Retry-After");
        m.put("RTT".toUpperCase(Locale.ENGLISH), "RTT");
        m.put("Save-Data".toUpperCase(Locale.ENGLISH), "Save-Data");
        m.put("Sec-WebSocket-Key1".toUpperCase(Locale.ENGLISH), "Sec-WebSocket-Key1");
        m.put("Sec-WebSocket-Key2".toUpperCase(Locale.ENGLISH), "Sec-WebSocket-Key2");
        m.put("Sec-WebSocket-Location".toUpperCase(Locale.ENGLISH), "Sec-WebSocket-Location");
        m.put("Sec-WebSocket-Origin".toUpperCase(Locale.ENGLISH), "Sec-WebSocket-Origin");
        m.put("Sec-WebSocket-Protocol".toUpperCase(Locale.ENGLISH), "Sec-WebSocket-Protocol");
        m.put("Sec-WebSocket-Version".toUpperCase(Locale.ENGLISH), "Sec-WebSocket-Version");
        m.put("Sec-WebSocket-Key".toUpperCase(Locale.ENGLISH), "Sec-WebSocket-Key");
        m.put("Sec-WebSocket-Accept".toUpperCase(Locale.ENGLISH), "Sec-WebSocket-Accept");
        m.put("Server".toUpperCase(Locale.ENGLISH), "Server");
        m.put("Set-Cookie".toUpperCase(Locale.ENGLISH), "Set-Cookie");
        m.put("Set-Cookie2".toUpperCase(Locale.ENGLISH), "Set-Cookie2");
        m.put("SourceMap".toUpperCase(Locale.ENGLISH), "SourceMap");
        m.put("TE".toUpperCase(Locale.ENGLISH), "TE");
        m.put("Trailer".toUpperCase(Locale.ENGLISH), "Trailer");
        m.put("Transfer-Encoding".toUpperCase(Locale.ENGLISH), "Transfer-Encoding");
        m.put("Upgrade".toUpperCase(Locale.ENGLISH), "Upgrade");
        m.put("User-Agent".toUpperCase(Locale.ENGLISH), "User-Agent");
        m.put("Vary".toUpperCase(Locale.ENGLISH), "Vary");
        m.put("Via".toUpperCase(Locale.ENGLISH), "Via");
        m.put("Viewport-Width".toUpperCase(Locale.ENGLISH), "Viewport-Width");
        m.put("Warning".toUpperCase(Locale.ENGLISH), "Warning");
        m.put("WebSocket-Location".toUpperCase(Locale.ENGLISH), "WebSocket-Location");
        m.put("WebSocket-Origin".toUpperCase(Locale.ENGLISH), "WebSocket-Origin");
        m.put("WebSocket-Protocol".toUpperCase(Locale.ENGLISH), "WebSocket-Protocol");
        m.put("Width".toUpperCase(Locale.ENGLISH), "Width");
        m.put("WWW-Authenticate".toUpperCase(Locale.ENGLISH), "WWW-Authenticate");
        m.put("X-Auth-Token".toUpperCase(Locale.ENGLISH), "X-Auth-Token");
        UPPERCASE_HEADER_TO_HEADER = Collections.unmodifiableMap(m);
    }

    private final class AzureParameters
    implements HttpParameters {
        private AzureParameters() {
        }

        public Optional<String> getFirst(CharSequence name) {
            ArgumentUtils.requireNonNull((String)"name", (Object)name);
            return Optional.ofNullable((String)AzureFunctionHttpRequest.this.azureRequest.getQueryParameters().get(name.toString()));
        }

        public List<String> getAll(CharSequence name) {
            String v;
            if (name != null && (v = (String)AzureFunctionHttpRequest.this.azureRequest.getQueryParameters().get(name.toString())) != null) {
                return Collections.singletonList(v);
            }
            return Collections.emptyList();
        }

        @Nullable
        public String get(CharSequence name) {
            return this.getFirst(name).orElse(null);
        }

        public Set<String> names() {
            return AzureFunctionHttpRequest.this.azureRequest.getQueryParameters().keySet();
        }

        public Collection<List<String>> values() {
            return AzureFunctionHttpRequest.this.azureRequest.getQueryParameters().values().stream().map(Collections::singletonList).toList();
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            String value;
            if (name != null && (value = (String)AzureFunctionHttpRequest.this.azureRequest.getQueryParameters().get(name.toString())) != null) {
                if (conversionContext.getArgument().getType().isInstance(value)) {
                    return Optional.of(value);
                }
                return ConversionService.SHARED.convert((Object)value, conversionContext);
            }
            return Optional.empty();
        }
    }
}

