/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import io.micronaut.azure.function.http.AzureMutableHeaders;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.servlet.http.ServletHttpResponse;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

@Internal
public class AzureFunctionHttpResponse<B>
implements ServletHttpResponse<HttpResponseMessage, B> {
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    private final HttpRequestMessage<Optional<String>> azureRequest;
    private MutableConvertibleValues<Object> attributes;
    private B body;
    private HttpStatus status = HttpStatus.OK;
    private ByteArrayOutputStream outputStream;
    private MutableHttpHeaders headers = new AzureMutableHeaders(new LinkedHashMap<CharSequence, List<String>>(5), ConversionService.SHARED);

    AzureFunctionHttpResponse(HttpRequestMessage<Optional<String>> azureRequest, MediaTypeCodecRegistry mediaTypeCodecRegistry) {
        this.azureRequest = azureRequest;
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() {
        ByteArrayOutputStream outputStream = this.outputStream;
        if (outputStream == null) {
            AzureFunctionHttpResponse azureFunctionHttpResponse = this;
            synchronized (azureFunctionHttpResponse) {
                outputStream = this.outputStream;
                if (outputStream == null) {
                    this.outputStream = outputStream = new ByteArrayOutputStream();
                }
            }
        }
        return outputStream;
    }

    public BufferedWriter getWriter() {
        return new BufferedWriter(new OutputStreamWriter(this.getOutputStream(), this.getCharacterEncoding()));
    }

    public MutableHttpResponse<B> cookie(Cookie cookie) {
        if (cookie instanceof NettyCookie) {
            NettyCookie nettyCookie = (NettyCookie)cookie;
            String encoded = ServerCookieEncoder.STRICT.encode(nettyCookie.getNettyCookie());
            this.header("Set-Cookie", encoded);
        }
        return this;
    }

    public <T> MutableHttpResponse<T> body(@Nullable T body) {
        if (body instanceof CharSequence && this.getContentType().isEmpty()) {
            this.contentType(MediaType.TEXT_PLAIN_TYPE);
        }
        this.body = body;
        return this;
    }

    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap attributes = this.attributes;
        if (attributes == null) {
            AzureFunctionHttpResponse azureFunctionHttpResponse = this;
            synchronized (azureFunctionHttpResponse) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap();
                }
            }
        }
        return attributes;
    }

    @NonNull
    public Optional<B> getBody() {
        if (this.outputStream != null) {
            return Optional.of(this.outputStream.toByteArray());
        }
        return Optional.ofNullable(this.body);
    }

    public MutableHttpResponse<B> status(HttpStatus status, CharSequence message) {
        ArgumentUtils.requireNonNull((String)"status", (Object)status);
        this.status = status;
        return this;
    }

    public MutableHttpResponse<B> status(int status, CharSequence message) {
        this.status = HttpStatus.valueOf((int)status);
        return this;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public int code() {
        return this.status.getCode();
    }

    public String reason() {
        return this.status.getReason();
    }

    public HttpResponseMessage getNativeResponse() {
        B b2 = this.body;
        if (b2 instanceof HttpResponseMessage.Builder) {
            HttpResponseMessage.Builder builder = (HttpResponseMessage.Builder)b2;
            return builder.build();
        }
        HttpResponseMessage.Builder responseBuilder = this.azureRequest.createResponseBuilder(com.microsoft.azure.functions.HttpStatus.valueOf((int)this.status.getCode()));
        this.getHeaders().forEach((s, strings) -> {
            for (String string : strings) {
                responseBuilder.header(s, string);
            }
        });
        this.getBody().ifPresent(b -> {
            if (b instanceof byte[]) {
                responseBuilder.body(b);
            } else {
                MediaTypeCodec codec = this.mediaTypeCodecRegistry.findCodec(this.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE), b.getClass()).orElse(null);
                if (codec != null) {
                    responseBuilder.body((Object)codec.encode(b));
                } else {
                    responseBuilder.body(b);
                }
            }
        });
        return responseBuilder.build();
    }
}

