/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.HttpMethod;
import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import io.micronaut.azure.function.AzureFunction;
import io.micronaut.azure.function.http.AzureFunctionHttpRequest;
import io.micronaut.azure.function.http.HttpHandler;
import io.micronaut.azure.function.http.HttpRequestMessageBuilder;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.context.ServerContextPathProvider;
import io.micronaut.runtime.exceptions.ApplicationStartupException;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpHandler;
import java.util.Objects;
import java.util.Optional;

public class AzureHttpFunction
extends AzureFunction {
    protected ServletHttpHandler<HttpRequestMessage<Optional<String>>, HttpResponseMessage> httpHandler;
    private final String contextPath;

    protected AzureHttpFunction() {
        this(null);
    }

    protected AzureHttpFunction(ApplicationContextBuilder applicationContextBuilder) {
        try {
            AzureFunction.startApplicationContext((ApplicationContextBuilder)applicationContextBuilder);
        }
        catch (Throwable e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Error initializing Azure function: " + e.getMessage(), e);
            }
            throw new ApplicationStartupException("Error initializing Azure function: " + e.getMessage(), e);
        }
        this.httpHandler = new HttpHandler(this.getApplicationContext());
        this.registerApplicationContextShutDownHook();
        this.registerHttpHandlerShutDownHook();
        applicationContext.registerSingleton((Object)this);
        this.contextPath = applicationContext.findBean(ServerContextPathProvider.class).map(ServerContextPathProvider::getContextPath).orElse("/api");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponseMessage route(HttpRequestMessage<Optional<String>> request, ExecutionContext executionContext) {
        try {
            AzureFunctionHttpRequest azureFunctionHttpRequest = new AzureFunctionHttpRequest(this.contextPath, request, this.httpHandler.getMediaTypeCodecRegistry(), executionContext);
            ServletExchange exchange = this.httpHandler.exchange(azureFunctionHttpRequest);
            HttpResponseMessage httpResponseMessage = (HttpResponseMessage)exchange.getResponse().getNativeResponse();
            return httpResponseMessage;
        }
        finally {
            applicationContext.destroyBean((Object)this);
        }
    }

    public HttpRequestMessageBuilder<?> request(HttpMethod method, String uri) {
        Objects.requireNonNull(uri, "The URI cannot be null");
        uri = StringUtils.prependUri((String)this.contextPath, (String)uri);
        return HttpRequestMessageBuilder.builder(method, uri, applicationContext);
    }

    public HttpRequestMessageBuilder<?> request(io.micronaut.http.HttpMethod method, String uri) {
        Objects.requireNonNull(method, "The method cannot be null");
        return this.request(HttpMethod.value((String)method.name()), uri);
    }

    private void registerHttpHandlerShutDownHook() {
        Runtime.getRuntime().addShutdownHook(this.createHttpHandlerShutDownHook());
    }

    private Thread createHttpHandlerShutDownHook() {
        return new Thread(() -> {
            this.httpHandler = null;
        });
    }
}

