/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.MutableConvertibleMultiValuesMap;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Internal
class AzureMultiValueMap
implements ConvertibleMultiValues<String> {
    final MutableConvertibleMultiValuesMap<String> map;
    ConversionService conversionService;

    AzureMultiValueMap(Map<CharSequence, List<String>> map, ConversionService conversionService) {
        this.map = new MutableConvertibleMultiValuesMap(map, conversionService);
        this.conversionService = conversionService;
    }

    public List<String> getAll(CharSequence name) {
        String v;
        if (name != null && (v = (String)this.map.get((CharSequence)name.toString())) != null) {
            return Collections.singletonList(v);
        }
        return Collections.emptyList();
    }

    @Nullable
    public String get(CharSequence name) {
        ArgumentUtils.requireNonNull((String)"name", (Object)name);
        return (String)this.map.get((CharSequence)name.toString());
    }

    public Set<String> names() {
        return this.map.names();
    }

    public Collection<List<String>> values() {
        return this.map.values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.map.get(name, conversionContext);
    }
}

