/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import io.micronaut.azure.function.http.AzureFunctionHttpRequest;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.ConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.servlet.http.ServletBodyBinder;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AzureServletBodyBinder<T>
extends ServletBodyBinder<T> {
    protected AzureServletBodyBinder(ConversionService conversionService, MediaTypeCodecRegistry mediaTypeCodecRegistry) {
        super(conversionService, mediaTypeCodecRegistry);
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        Optional<ConvertibleValues<?>> bodyParameters;
        AzureFunctionHttpRequest azureFunctionRequest;
        Optional formBody;
        MediaType mediaType = source.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        if (source instanceof AzureFunctionHttpRequest && this.isFormSubmitted(mediaType) && (formBody = (Optional)(azureFunctionRequest = (AzureFunctionHttpRequest)source).getNativeRequest().getBody()).isPresent() && (bodyParameters = this.formUrlEncodedBodyToConvertibleValues((String)formBody.get())).isPresent()) {
            ConvertibleValues<?> convertibleBodyParameters = bodyParameters.get();
            Argument argument = context.getArgument();
            Optional nestedBodyName = argument.getAnnotationMetadata().stringValue(Body.class);
            if (nestedBodyName.isPresent()) {
                return () -> convertibleBodyParameters.get((CharSequence)nestedBodyName.get(), context);
            }
            Optional result = this.conversionService.convert((Object)convertibleBodyParameters.asMap(), context);
            return () -> result;
        }
        return super.bind(context, source);
    }

    private Optional<ConvertibleValues<?>> formUrlEncodedBodyToConvertibleValues(String body) {
        ConvertibleValuesMap convertibleFormParameters = this.formUrlEncodedBodyToMap(body).map(ConvertibleValuesMap::new).orElse(null);
        return Optional.ofNullable(convertibleFormParameters);
    }

    private Optional<Map<String, List<String>>> formUrlEncodedBodyToMap(String body) {
        QueryStringDecoder decoder = new QueryStringDecoder(body, false);
        Map parameters = decoder.parameters();
        return CollectionUtils.isEmpty((Map)parameters) ? Optional.empty() : Optional.of(parameters);
    }

    private boolean isFormSubmitted(MediaType contentType) {
        return MediaType.APPLICATION_FORM_URLENCODED_TYPE.equals((Object)contentType) || MediaType.MULTIPART_FORM_DATA_TYPE.equals((Object)contentType);
    }
}

