/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import com.microsoft.azure.functions.HttpMethod;
import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import com.microsoft.azure.functions.HttpStatus;
import com.microsoft.azure.functions.HttpStatusType;
import io.micronaut.azure.function.http.HttpRequestMessageBuilder;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class DefaultHttpRequestMessageBuilder<T>
implements HttpRequestMessageBuilder<T>,
HttpRequestMessage<T> {
    private final ApplicationContext applicationContext;
    private HttpMethod method = HttpMethod.GET;
    private URI uri;
    private final Map<String, String> headers = new LinkedHashMap<String, String>(3);
    private final Map<String, String> queryParams = new LinkedHashMap<String, String>(3);
    private Object body;

    public DefaultHttpRequestMessageBuilder(HttpMethod method, URI uri, ApplicationContext applicationContext) {
        this.method(method);
        this.uri(uri);
        this.applicationContext = applicationContext;
    }

    @Override
    public HttpRequestMessageBuilder<T> method(HttpMethod method) {
        this.method = Objects.requireNonNull(method, "The method cannot be null");
        return this;
    }

    @Override
    public HttpRequestMessageBuilder<T> uri(URI uri) {
        this.uri = Objects.requireNonNull(uri, "The URI cannot be null");
        return this;
    }

    @Override
    public HttpRequestMessageBuilder<T> header(String name, String value) {
        String headerName = Objects.requireNonNull(name, "The name cannot be null");
        if (value == null) {
            this.headers.remove(headerName);
        } else {
            this.headers.put(headerName, value);
        }
        return this;
    }

    @Override
    public HttpRequestMessageBuilder<T> parameter(String name, String value) {
        String headerName = Objects.requireNonNull(name, "The name cannot be null");
        if (value == null) {
            this.queryParams.remove(headerName);
        } else {
            this.queryParams.put(headerName, value);
        }
        return this;
    }

    @Override
    public <B> HttpRequestMessageBuilder<B> body(B body) {
        this.body = body;
        return this;
    }

    @Override
    public HttpRequestMessage<T> build() {
        return this;
    }

    @Override
    public HttpRequestMessage<Optional<String>> buildEncoded() {
        return this.buildEncodedRequest();
    }

    private HttpRequestMessage<Optional<String>> buildEncodedRequest() {
        if (this.body != null) {
            if (this.body instanceof byte[]) {
                this.body = Optional.of((byte[])this.body);
            } else if (this.body instanceof CharSequence) {
                this.body = Optional.of(this.body.toString());
            } else {
                MediaTypeCodec codec;
                MediaTypeCodecRegistry codecRegistry = (MediaTypeCodecRegistry)this.applicationContext.getBean(MediaTypeCodecRegistry.class);
                String ct = this.getHeaders().get("Content-Type");
                MediaType mediaType = MediaType.APPLICATION_JSON_TYPE;
                if (ct != null) {
                    mediaType = new MediaType(ct);
                }
                this.body = (codec = (MediaTypeCodec)codecRegistry.findCodec(mediaType, this.body.getClass()).orElse(null)) != null ? Optional.of(new String(codec.encode(this.body), StandardCharsets.UTF_8)) : Optional.of(this.body.toString());
            }
        } else {
            this.body = Optional.empty();
        }
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    public HttpMethod getHttpMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParams;
    }

    public T getBody() {
        return (T)this.body;
    }

    public HttpResponseMessage.Builder createResponseBuilder(HttpStatus status) {
        return new ResponseBuilder().status((HttpStatusType)status);
    }

    public HttpResponseMessage.Builder createResponseBuilder(HttpStatusType status) {
        return new ResponseBuilder().status(status);
    }

    private static class ResponseBuilder
    implements HttpResponseMessage.Builder,
    HttpResponseMessage,
    HttpHeaders {
        private HttpStatusType status = HttpStatus.OK;
        private final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>(3);
        private Object body;

        private ResponseBuilder() {
        }

        public HttpResponseMessage.Builder status(HttpStatusType status) {
            this.status = status;
            return this;
        }

        public HttpResponseMessage.Builder header(String key, String value) {
            this.headers.computeIfAbsent(key, k -> new ArrayList()).add(value);
            return this;
        }

        public HttpResponseMessage.Builder body(Object body) {
            this.body = body;
            return this;
        }

        public HttpResponseMessage build() {
            return this;
        }

        public HttpStatusType getStatus() {
            return this.status;
        }

        public String getHeader(String key) {
            List<String> v = this.headers.get(key);
            if (CollectionUtils.isNotEmpty(v)) {
                return v.iterator().next();
            }
            return null;
        }

        public Object getBody() {
            return this.body;
        }

        public List<String> getAll(CharSequence name) {
            List<String> values = this.headers.get(name.toString());
            if (values != null) {
                return Collections.unmodifiableList(values);
            }
            return Collections.emptyList();
        }

        public String get(CharSequence name) {
            return this.getHeader(name.toString());
        }

        public Set<String> names() {
            return this.headers.keySet();
        }

        public Collection<List<String>> values() {
            return this.headers.values();
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            return ConversionService.SHARED.convert((Object)name.toString(), conversionContext);
        }
    }
}

