/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpHandler;
import io.netty.util.internal.MacAddressUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.Optional;

@Internal
public class HttpHandler
extends ServletHttpHandler<HttpRequestMessage<Optional<String>>, HttpResponseMessage> {
    public HttpHandler(ApplicationContext applicationContext) {
        super(HttpHandler.init(applicationContext), (ConversionService)applicationContext.getBean(ConversionService.class));
    }

    private static ApplicationContext init(ApplicationContext applicationContext) {
        HttpHandler.setIoNettyMachineIdSystemProperty();
        return applicationContext;
    }

    private static void setIoNettyMachineIdSystemProperty() {
        byte[] bestMacAddr = new byte[8];
        PlatformDependent.threadLocalRandom().nextBytes(bestMacAddr);
        System.setProperty("io.netty.machineId", MacAddressUtil.formatAddress((byte[])bestMacAddr));
    }

    public boolean isRunning() {
        return super.getApplicationContext().isRunning();
    }

    protected ServletExchange<HttpRequestMessage<Optional<String>>, HttpResponseMessage> createExchange(HttpRequestMessage<Optional<String>> request, HttpResponseMessage response) {
        throw new UnsupportedOperationException("Creating the exchange directly is not supported");
    }
}

