/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import com.microsoft.azure.functions.HttpMethod;
import com.microsoft.azure.functions.HttpRequestMessage;
import io.micronaut.azure.function.http.DefaultHttpRequestMessageBuilder;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.NonNull;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

public interface HttpRequestMessageBuilder<T> {
    public HttpRequestMessageBuilder<T> method(HttpMethod var1);

    public HttpRequestMessageBuilder<T> uri(URI var1);

    public HttpRequestMessageBuilder<T> header(String var1, String var2);

    public HttpRequestMessageBuilder<T> parameter(String var1, String var2);

    public <B> HttpRequestMessageBuilder<B> body(B var1);

    public HttpRequestMessage<T> build();

    public HttpRequestMessage<Optional<String>> buildEncoded();

    default public HttpRequestMessageBuilder<T> method(io.micronaut.http.HttpMethod method) {
        return this.method(HttpMethod.value((String)method.name()));
    }

    default public HttpRequestMessageBuilder<T> method(String method) {
        return this.method(HttpMethod.value((String)Objects.requireNonNull(method, "The method cannot be null")));
    }

    default public HttpRequestMessageBuilder<T> uri(String uri) {
        return this.uri(URI.create(uri));
    }

    public static <T> HttpRequestMessageBuilder<T> builder(HttpMethod method, String uri, @NonNull ApplicationContext applicationContext) {
        return new DefaultHttpRequestMessageBuilder(Objects.requireNonNull(method, "method cannot be null"), URI.create(Objects.requireNonNull(uri, "URI cannot be null")), Objects.requireNonNull(applicationContext, "application context cannot be null"));
    }
}

