/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import io.micronaut.azure.function.http.HttpRequestMessageHandler;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.servlet.http.ServletExchange;
import io.netty.util.internal.MacAddressUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.Optional;

@Internal
class HttpHandler
extends HttpRequestMessageHandler {
    public HttpHandler(ApplicationContext applicationContext) {
        super(HttpHandler.init(applicationContext));
    }

    private static ApplicationContext init(ApplicationContext applicationContext) {
        HttpHandler.setIoNettyMachineIdSystemProperty();
        return applicationContext;
    }

    private static void setIoNettyMachineIdSystemProperty() {
        byte[] bestMacAddr = new byte[8];
        PlatformDependent.threadLocalRandom().nextBytes(bestMacAddr);
        System.setProperty("io.netty.machineId", MacAddressUtil.formatAddress((byte[])bestMacAddr));
    }

    @Override
    protected ServletExchange<HttpRequestMessage<Optional<String>>, HttpResponseMessage> createExchange(HttpRequestMessage<Optional<String>> request, HttpResponseMessage response) {
        throw new UnsupportedOperationException("Creating the exchange directly is not supported");
    }
}

