/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import com.microsoft.azure.functions.HttpResponseMessage;
import com.microsoft.azure.functions.HttpStatus;
import com.microsoft.azure.functions.HttpStatusType;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpHeaders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Internal
public class ResponseBuilder
implements HttpResponseMessage.Builder,
HttpResponseMessage,
HttpHeaders {
    private HttpStatusType status = HttpStatus.OK;
    private final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>(3);
    private Object body;

    public HttpResponseMessage.Builder status(HttpStatusType status) {
        this.status = status;
        return this;
    }

    public HttpResponseMessage.Builder header(String key, String value) {
        this.headers.computeIfAbsent(key, k -> new ArrayList()).add(value);
        return this;
    }

    public HttpResponseMessage.Builder body(Object body) {
        this.body = body;
        return this;
    }

    public HttpResponseMessage build() {
        return this;
    }

    public HttpStatusType getStatus() {
        return this.status;
    }

    public String getHeader(String key) {
        List<String> v = this.headers.get(key);
        if (CollectionUtils.isNotEmpty(v)) {
            return v.iterator().next();
        }
        return null;
    }

    public Object getBody() {
        return this.body;
    }

    public List<String> getAll(CharSequence name) {
        List<String> values = this.headers.get(name.toString());
        if (values != null) {
            return Collections.unmodifiableList(values);
        }
        return Collections.emptyList();
    }

    public String get(CharSequence name) {
        return this.getHeader(name.toString());
    }

    public Set<String> names() {
        return this.headers.keySet();
    }

    public Collection<List<String>> values() {
        return this.headers.values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return ConversionService.SHARED.convert((Object)name.toString(), conversionContext);
    }
}

