/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Internal
public final class AzureCookies
implements Cookies {
    private final ConversionService conversionService;
    private final Map<CharSequence, io.micronaut.http.cookie.Cookie> cookies;

    public AzureCookies(String path, HttpHeaders headers, ConversionService conversionService) {
        this.conversionService = conversionService;
        String value = (String)headers.get((CharSequence)"Cookie");
        if (value != null) {
            this.cookies = new LinkedHashMap<CharSequence, io.micronaut.http.cookie.Cookie>(10);
            Set nettyCookies = ServerCookieDecoder.STRICT.decode(value);
            for (Cookie nettyCookie : nettyCookies) {
                String cookiePath = nettyCookie.path();
                if (cookiePath != null) {
                    if (!path.startsWith(cookiePath)) continue;
                    this.cookies.put(nettyCookie.name(), (io.micronaut.http.cookie.Cookie)new NettyCookie(nettyCookie));
                    continue;
                }
                this.cookies.put(nettyCookie.name(), (io.micronaut.http.cookie.Cookie)new NettyCookie(nettyCookie));
            }
        } else {
            this.cookies = Collections.emptyMap();
        }
    }

    public Set<io.micronaut.http.cookie.Cookie> getAll() {
        return new HashSet<io.micronaut.http.cookie.Cookie>(this.cookies.values());
    }

    public Optional<io.micronaut.http.cookie.Cookie> findCookie(CharSequence name) {
        io.micronaut.http.cookie.Cookie cookie = this.cookies.get(name);
        return cookie != null ? Optional.of(cookie) : Optional.empty();
    }

    public <T> Optional<T> get(CharSequence name, Class<T> requiredType) {
        if (requiredType == io.micronaut.http.cookie.Cookie.class || requiredType == Object.class) {
            return this.findCookie(name);
        }
        return this.findCookie(name).flatMap(cookie -> this.conversionService.convert((Object)cookie.getValue(), requiredType));
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.findCookie(name).flatMap(cookie -> this.conversionService.convert((Object)cookie.getValue(), conversionContext));
    }

    public Collection<io.micronaut.http.cookie.Cookie> values() {
        return Collections.unmodifiableCollection(this.cookies.values());
    }
}

