/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import io.micronaut.azure.function.http.BinaryContentConfiguration;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.http.CaseInsensitiveMutableHttpHeaders;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.servlet.http.ServletHttpResponse;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class AzureFunctionHttpResponse<B>
implements ServletHttpResponse<HttpResponseMessage, B> {
    private static final Logger LOG = LoggerFactory.getLogger(AzureFunctionHttpResponse.class);
    private final ByteArrayOutputStream body = new ByteArrayOutputStream();
    private int status = HttpStatus.OK.getCode();
    private final HttpRequestMessage<Optional<String>> azureRequest;
    private final MutableHttpHeaders headers;
    private final BinaryContentConfiguration binaryContentConfiguration;
    private MutableConvertibleValues<Object> attributes;
    private B bodyObject;
    private String reason = HttpStatus.OK.getReason();

    public AzureFunctionHttpResponse(HttpRequestMessage<Optional<String>> azureRequest, ConversionService conversionService, BinaryContentConfiguration binaryContentConfiguration) {
        this.azureRequest = azureRequest;
        this.headers = new CaseInsensitiveMutableHttpHeaders(conversionService);
        this.binaryContentConfiguration = binaryContentConfiguration;
    }

    public OutputStream getOutputStream() {
        return this.body;
    }

    public BufferedWriter getWriter() {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)this.body, this.getCharacterEncoding()));
    }

    public MutableHttpResponse<B> cookie(Cookie cookie) {
        if (cookie instanceof NettyCookie) {
            NettyCookie nettyCookie = (NettyCookie)cookie;
            String encoded = ServerCookieEncoder.STRICT.encode(nettyCookie.getNettyCookie());
            this.header("Set-Cookie", encoded);
        }
        return this;
    }

    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap localAttributes = this.attributes;
        if (localAttributes == null) {
            AzureFunctionHttpResponse azureFunctionHttpResponse = this;
            synchronized (azureFunctionHttpResponse) {
                localAttributes = this.attributes;
                if (localAttributes == null) {
                    this.attributes = localAttributes = new MutableConvertibleValuesMap();
                }
            }
        }
        return localAttributes;
    }

    public Optional<B> getBody() {
        return Optional.ofNullable(this.bodyObject);
    }

    public <T> MutableHttpResponse<T> body(@Nullable T body) {
        this.bodyObject = body;
        return this;
    }

    public MutableHttpResponse<B> status(int status, CharSequence message) {
        this.status = status;
        this.reason = message == null ? HttpStatus.getDefaultReason((int)status) : message.toString();
        return this;
    }

    public int code() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public HttpResponseMessage getNativeResponse() {
        LOG.trace("Creating Azure Function HTTP Response");
        B b = this.bodyObject;
        if (b instanceof HttpResponseMessage.Builder) {
            HttpResponseMessage.Builder builder = (HttpResponseMessage.Builder)b;
            LOG.trace("Using Azure Function HTTP Response Builder");
            return builder.build();
        }
        HttpResponseMessage.Builder responseBuilder = this.azureRequest.createResponseBuilder(com.microsoft.azure.functions.HttpStatus.valueOf((int)this.status));
        this.getHeaders().forEach((s, strings) -> {
            for (String string : strings) {
                responseBuilder.header(s, string);
            }
        });
        if (this.bodyObject != null) {
            if (this.binaryContentConfiguration.isBinary(this.getHeaders().getContentType().orElse(null))) {
                responseBuilder.body((Object)this.body.toByteArray());
            } else {
                responseBuilder.body((Object)this.body.toString(this.getCharacterEncoding()));
            }
        }
        return responseBuilder.build();
    }
}

