/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import io.micronaut.azure.function.AzureFunction;
import io.micronaut.azure.function.http.AzureFunctionHttpRequest;
import io.micronaut.azure.function.http.AzureFunctionHttpResponse;
import io.micronaut.azure.function.http.BinaryContentConfiguration;
import io.micronaut.azure.function.http.HttpHandler;
import io.micronaut.azure.function.http.HttpRequestMessageBuilder;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpMethod;
import io.micronaut.runtime.exceptions.ApplicationStartupException;
import io.micronaut.servlet.http.BodyBuilder;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpHandler;
import java.util.Objects;
import java.util.Optional;

public class AzureHttpFunction
extends AzureFunction {
    protected ServletHttpHandler<HttpRequestMessage<Optional<String>>, HttpResponseMessage> httpHandler;

    protected AzureHttpFunction() {
        this(null);
    }

    public AzureHttpFunction(ApplicationContextBuilder applicationContextBuilder) {
        try {
            AzureFunction.startApplicationContext((ApplicationContextBuilder)applicationContextBuilder);
        }
        catch (Throwable e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Error initializing Azure function: " + e.getMessage(), e);
            }
            throw new ApplicationStartupException("Error initializing Azure function: " + e.getMessage(), e);
        }
        this.httpHandler = new HttpHandler(this.getApplicationContext());
        this.registerApplicationContextShutDownHook();
        this.registerHttpHandlerShutDownHook();
        applicationContext.registerSingleton((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponseMessage route(HttpRequestMessage<Optional<String>> request, ExecutionContext executionContext) {
        try {
            AzureFunctionHttpRequest azureFunctionHttpRequest = new AzureFunctionHttpRequest(request, new AzureFunctionHttpResponse<Object>(request, (ConversionService)this.httpHandler.getApplicationContext().getBean(ConversionService.class), (BinaryContentConfiguration)this.httpHandler.getApplicationContext().getBean(BinaryContentConfiguration.class)), executionContext, (ConversionService)this.httpHandler.getApplicationContext().getBean(ConversionService.class), (BinaryContentConfiguration)this.httpHandler.getApplicationContext().getBean(BinaryContentConfiguration.class), (BodyBuilder)this.httpHandler.getApplicationContext().getBean(BodyBuilder.class));
            ServletExchange exchange = this.httpHandler.exchange(azureFunctionHttpRequest);
            HttpResponseMessage httpResponseMessage = (HttpResponseMessage)exchange.getResponse().getNativeResponse();
            return httpResponseMessage;
        }
        finally {
            applicationContext.destroyBean((Object)this);
        }
    }

    public HttpRequestMessageBuilder<?> request(com.microsoft.azure.functions.HttpMethod method, String uri) {
        Objects.requireNonNull(uri, "The URI cannot be null");
        return HttpRequestMessageBuilder.builder(method, uri, applicationContext);
    }

    public HttpRequestMessageBuilder<?> request(HttpMethod method, String uri) {
        Objects.requireNonNull(method, "The method cannot be null");
        return this.request(com.microsoft.azure.functions.HttpMethod.value((String)method.name()), uri);
    }

    private void registerHttpHandlerShutDownHook() {
        Runtime.getRuntime().addShutdownHook(this.createHttpHandlerShutDownHook());
    }

    private Thread createHttpHandlerShutDownHook() {
        return new Thread(() -> {
            this.httpHandler = null;
        });
    }
}

