/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import com.microsoft.azure.functions.HttpMethod;
import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import com.microsoft.azure.functions.HttpStatus;
import com.microsoft.azure.functions.HttpStatusType;
import io.micronaut.azure.function.http.AzureHttpFunction;
import io.micronaut.azure.function.http.DefaultExecutionContext;
import io.micronaut.azure.function.http.HttpRequestMessageBuilder;
import io.micronaut.azure.function.http.ResponseBuilder;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Internal
class DefaultHttpRequestMessageBuilder<T>
implements HttpRequestMessageBuilder<T>,
HttpRequestMessage<T> {
    private final ApplicationContext applicationContext;
    private HttpMethod method = HttpMethod.GET;
    private URI uri;
    private final Map<String, String> headers = new LinkedHashMap<String, String>(3);
    private final Map<String, String> queryParams = new LinkedHashMap<String, String>(3);
    private Object body;

    public DefaultHttpRequestMessageBuilder(HttpMethod method, URI uri, ApplicationContext applicationContext) {
        this.method(method);
        this.uri(uri);
        this.applicationContext = applicationContext;
    }

    @Override
    public HttpRequestMessageBuilder<T> method(HttpMethod method) {
        this.method = Objects.requireNonNull(method, "The method cannot be null");
        return this;
    }

    @Override
    public HttpRequestMessageBuilder<T> uri(URI uri) {
        this.uri = Objects.requireNonNull(uri, "The URI cannot be null");
        return this;
    }

    @Override
    public HttpRequestMessageBuilder<T> header(String name, String value) {
        String headerName = Objects.requireNonNull(name, "The name cannot be null");
        if (value == null) {
            this.headers.remove(headerName);
        } else {
            this.headers.put(headerName, value);
        }
        return this;
    }

    @Override
    public HttpRequestMessageBuilder<T> parameter(String name, String value) {
        String headerName = Objects.requireNonNull(name, "The name cannot be null");
        if (value == null) {
            this.queryParams.remove(headerName);
        } else {
            this.queryParams.put(headerName, value);
        }
        return this;
    }

    @Override
    public <B> HttpRequestMessageBuilder<B> body(B body) {
        this.body = body;
        return this;
    }

    @Override
    public HttpRequestMessage<T> build() {
        return this;
    }

    @Override
    public HttpRequestMessage<Optional<String>> buildEncoded() {
        return this.buildEncodedRequest();
    }

    @Override
    public HttpResponseMessage invoke() {
        return ((AzureHttpFunction)((Object)this.applicationContext.getBean(AzureHttpFunction.class))).route(this.buildEncodedRequest(), new DefaultExecutionContext());
    }

    private HttpRequestMessage<Optional<String>> buildEncodedRequest() {
        if (this.body != null) {
            Object object = this.body;
            if (object instanceof byte[]) {
                byte[] byteArr = (byte[])object;
                this.body = Optional.of(byteArr);
            } else if (this.body instanceof CharSequence) {
                this.body = Optional.of(this.body.toString());
            } else {
                MediaTypeCodec codec;
                MediaTypeCodecRegistry codecRegistry = (MediaTypeCodecRegistry)this.applicationContext.getBean(MediaTypeCodecRegistry.class);
                String ct = this.getHeaders().get("Content-Type");
                MediaType mediaType = MediaType.APPLICATION_JSON_TYPE;
                if (ct != null) {
                    mediaType = new MediaType(ct);
                }
                this.body = (codec = (MediaTypeCodec)codecRegistry.findCodec(mediaType, this.body.getClass()).orElse(null)) != null ? Optional.of(new String(codec.encode(this.body), StandardCharsets.UTF_8)) : Optional.of(this.body.toString());
            }
        } else {
            this.body = Optional.empty();
        }
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    public HttpMethod getHttpMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParams;
    }

    public T getBody() {
        return (T)this.body;
    }

    public HttpResponseMessage.Builder createResponseBuilder(HttpStatus status) {
        return new ResponseBuilder().status((HttpStatusType)status);
    }

    public HttpResponseMessage.Builder createResponseBuilder(HttpStatusType status) {
        return new ResponseBuilder().status(status);
    }
}

