/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.cookie.ServerCookieDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Internal
public final class AzureCookies
implements Cookies {
    private final ConversionService conversionService;
    private final Map<CharSequence, Cookie> cookies;

    public AzureCookies(String path, HttpHeaders headers, ConversionService conversionService) {
        this.conversionService = conversionService;
        String value = (String)headers.get((CharSequence)"Cookie");
        if (value != null) {
            List cookieList = ServerCookieDecoder.INSTANCE.decode(value);
            this.cookies = new LinkedHashMap<CharSequence, Cookie>(cookieList.size());
            cookieList.stream().filter(c -> c.getPath() == null || path.startsWith(c.getPath())).forEach(c -> this.cookies.put(c.getName(), (Cookie)c));
        } else {
            this.cookies = Collections.emptyMap();
        }
    }

    public Set<Cookie> getAll() {
        return new HashSet<Cookie>(this.cookies.values());
    }

    public Optional<Cookie> findCookie(CharSequence name) {
        Cookie cookie = this.cookies.get(name);
        return cookie != null ? Optional.of(cookie) : Optional.empty();
    }

    public <T> Optional<T> get(CharSequence name, Class<T> requiredType) {
        if (requiredType == Cookie.class || requiredType == Object.class) {
            return this.findCookie(name);
        }
        return this.findCookie(name).flatMap(cookie -> this.conversionService.convert((Object)cookie.getValue(), requiredType));
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.findCookie(name).flatMap(cookie -> this.conversionService.convert((Object)cookie.getValue(), conversionContext));
    }

    public Collection<Cookie> values() {
        return Collections.unmodifiableCollection(this.cookies.values());
    }
}

