/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import io.micronaut.azure.function.http.AzureCookies;
import io.micronaut.azure.function.http.AzureFunctionHttpResponse;
import io.micronaut.azure.function.http.QueryStringDecoder;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.function.BinaryTypeConfiguration;
import io.micronaut.http.CaseInsensitiveMutableHttpHeaders;
import io.micronaut.http.FullHttpRequest;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpParameters;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.simple.SimpleHttpParameters;
import io.micronaut.servlet.http.BodyBuilder;
import io.micronaut.servlet.http.ByteArrayByteBuffer;
import io.micronaut.servlet.http.MutableServletHttpRequest;
import io.micronaut.servlet.http.ParsedBodyHolder;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpRequest;
import io.micronaut.servlet.http.ServletHttpResponse;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class AzureFunctionHttpRequest<T>
implements MutableServletHttpRequest<HttpRequestMessage<Optional<String>>, T>,
ServletExchange<HttpRequestMessage<Optional<String>>, HttpResponseMessage>,
FullHttpRequest<T>,
ParsedBodyHolder<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AzureFunctionHttpRequest.class);
    private final ExecutionContext executionContext;
    private final BinaryTypeConfiguration binaryTypeConfiguration;
    private ConversionService conversionService;
    private final HttpRequestMessage<Optional<String>> requestEvent;
    private final AzureFunctionHttpResponse<Object> response;
    private URI uri;
    private final HttpMethod httpMethod;
    private Cookies cookies;
    private MutableConvertibleValues<Object> attributes;
    private Supplier<Optional<T>> body;
    private T parsedBody;
    private T overriddenBody;
    private ByteArrayByteBuffer<T> servletByteBuffer;

    public AzureFunctionHttpRequest(HttpRequestMessage<Optional<String>> request, AzureFunctionHttpResponse<Object> response, ExecutionContext executionContext, ConversionService conversionService, BinaryTypeConfiguration binaryTypeConfiguration, BodyBuilder bodyBuilder) {
        this.executionContext = executionContext;
        this.conversionService = conversionService;
        this.binaryTypeConfiguration = binaryTypeConfiguration;
        this.requestEvent = request;
        this.response = response;
        this.uri = this.requestEvent.getUri();
        this.httpMethod = AzureFunctionHttpRequest.parseMethod(() -> this.requestEvent.getHttpMethod().name());
        this.body = SupplierUtil.memoizedNonEmpty(() -> {
            T built = this.parsedBody != null ? this.parsedBody : bodyBuilder.buildBody(this::getInputStream, (HttpRequest)this);
            return Optional.ofNullable(built);
        });
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public byte[] getBodyBytes() throws IOException {
        if (((Optional)this.requestEvent.getBody()).isPresent()) {
            return this.getBodyBytes(((Optional)this.requestEvent.getBody())::get, () -> this.binaryTypeConfiguration.isMediaTypeBinary((String)this.requestEvent.getHeaders().get("Content-Type")));
        }
        return ArrayUtils.EMPTY_BYTE_ARRAY;
    }

    protected static HttpMethod parseMethod(Supplier<String> httpMethodConsumer) {
        try {
            return HttpMethod.valueOf((String)httpMethodConsumer.get());
        }
        catch (IllegalArgumentException e) {
            return HttpMethod.CUSTOM;
        }
    }

    public MutableHttpHeaders getHeaders() {
        Map<String, List<String>> headersMap = AzureFunctionHttpRequest.transformCommaSeparatedValue(this.requestEvent.getHeaders());
        return new CaseInsensitiveMutableHttpHeaders(headersMap, this.conversionService);
    }

    public MutableHttpParameters getParameters() {
        MediaType mediaType = this.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        HashMap<String, List<String>> values = new HashMap<String, List<String>>(AzureFunctionHttpRequest.transformCommaSeparatedValue(this.requestEvent.getQueryParameters()));
        if (this.isFormSubmission(mediaType)) {
            Map<Object, Object> parameters = null;
            try {
                parameters = new QueryStringDecoder(new String(this.getBodyBytes(), this.getCharacterEncoding()), false).parameters();
            }
            catch (IOException ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error decoding form data: " + ex.getMessage(), (Throwable)ex);
                }
                parameters = new HashMap();
            }
            values.putAll(parameters);
        }
        return new SimpleHttpParameters(values, this.conversionService);
    }

    public ServletHttpResponse<HttpResponseMessage, ?> getResponse() {
        return this.response;
    }

    public InputStream getInputStream() throws IOException {
        return this.servletByteBuffer != null ? this.servletByteBuffer.toInputStream() : new ByteArrayInputStream(this.getBodyBytes());
    }

    public ServletHttpRequest<HttpRequestMessage<Optional<String>>, ? super Object> getRequest() {
        return this;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader(this.getInputStream(), this.getCharacterEncoding()));
    }

    public HttpRequestMessage<Optional<String>> getNativeRequest() {
        return this.requestEvent;
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public URI getUri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Cookies getCookies() {
        Cookies localCookies = this.cookies;
        if (localCookies == null) {
            AzureFunctionHttpRequest azureFunctionHttpRequest = this;
            synchronized (azureFunctionHttpRequest) {
                localCookies = this.cookies;
                if (localCookies == null) {
                    this.cookies = localCookies = new AzureCookies(this.getPath(), (HttpHeaders)this.getHeaders(), this.conversionService);
                }
            }
        }
        return localCookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap localAttributes = this.attributes;
        if (localAttributes == null) {
            AzureFunctionHttpRequest azureFunctionHttpRequest = this;
            synchronized (azureFunctionHttpRequest) {
                localAttributes = this.attributes;
                if (localAttributes == null) {
                    this.attributes = localAttributes = new MutableConvertibleValuesMap();
                }
            }
        }
        return localAttributes;
    }

    @NonNull
    public Optional<T> getBody() {
        if (this.overriddenBody != null) {
            return Optional.of(this.overriddenBody);
        }
        return this.body.get();
    }

    @NonNull
    public <B> Optional<B> getBody(Argument<B> arg) {
        return this.getBody().map(t -> this.conversionService.convertRequired(t, arg));
    }

    protected boolean isFormSubmission(MediaType contentType) {
        return MediaType.APPLICATION_FORM_URLENCODED_TYPE.equals((Object)contentType) || MediaType.MULTIPART_FORM_DATA_TYPE.equals((Object)contentType);
    }

    public MutableHttpRequest<T> cookie(Cookie cookie) {
        return this;
    }

    public MutableHttpRequest<T> uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public <B> MutableHttpRequest<B> body(B body) {
        this.overriddenBody = body;
        return this;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setParsedBody(T body) {
        this.parsedBody = body;
    }

    @Nullable
    public ByteBuffer<?> contents() {
        try {
            if (this.servletByteBuffer == null) {
                this.servletByteBuffer = new ByteArrayByteBuffer(this.getInputStream().readAllBytes());
            }
            return this.servletByteBuffer;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error getting all body contents", e);
        }
    }

    @Nullable
    public ExecutionFlow<ByteBuffer<?>> bufferContents() {
        return ExecutionFlow.just(this.contents());
    }

    protected byte[] getBodyBytes(@NonNull Supplier<String> bodySupplier, @NonNull BooleanSupplier base64EncodedSupplier) throws IOException {
        String requestBody = bodySupplier.get();
        if (StringUtils.isEmpty((CharSequence)requestBody)) {
            throw new IOException("Empty Body");
        }
        return base64EncodedSupplier.getAsBoolean() ? Base64.getDecoder().decode(requestBody) : requestBody.getBytes(this.getCharacterEncoding());
    }

    @NonNull
    private static List<String> splitCommaSeparatedValue(@Nullable String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        String[] arr = value.split(",");
        ArrayList<String> result = new ArrayList<String>();
        for (String str : arr) {
            result.add(str.trim());
        }
        return result;
    }

    @NonNull
    private static Map<String, List<String>> transformCommaSeparatedValue(@Nullable Map<String, String> input) {
        if (input == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : input.entrySet()) {
            output.put(entry.getKey(), AzureFunctionHttpRequest.splitCommaSeparatedValue(entry.getValue()));
        }
        return output;
    }
}

