/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function.http;

import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.HttpMethod;
import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import io.micronaut.azure.function.AzureFunction;
import io.micronaut.azure.function.http.AzureFunctionHttpRequest;
import io.micronaut.azure.function.http.AzureFunctionHttpResponse;
import io.micronaut.azure.function.http.HttpHandler;
import io.micronaut.azure.function.http.HttpRequestMessageBuilder;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.function.BinaryTypeConfiguration;
import io.micronaut.servlet.http.BodyBuilder;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpHandler;
import java.util.Objects;
import java.util.Optional;

public class AzureHttpFunction
extends AzureFunction {
    protected ServletHttpHandler<HttpRequestMessage<Optional<String>>, HttpResponseMessage> httpHandler;

    protected AzureHttpFunction() {
        this(null);
    }

    public AzureHttpFunction(ApplicationContextBuilder applicationContextBuilder) {
        super(applicationContextBuilder);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Initializing AzureHttpFunction");
        }
        this.httpHandler = new HttpHandler(this.getApplicationContext());
        this.registerHttpHandlerShutDownHook();
        this.getApplicationContext().registerSingleton((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponseMessage route(HttpRequestMessage<Optional<String>> request, ExecutionContext executionContext) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Route request: {}", request);
        }
        try {
            AzureFunctionHttpRequest azureFunctionHttpRequest = new AzureFunctionHttpRequest(request, new AzureFunctionHttpResponse<Object>(request, (ConversionService)this.httpHandler.getApplicationContext().getBean(ConversionService.class), (BinaryTypeConfiguration)this.httpHandler.getApplicationContext().getBean(BinaryTypeConfiguration.class)), executionContext, (ConversionService)this.httpHandler.getApplicationContext().getBean(ConversionService.class), (BinaryTypeConfiguration)this.httpHandler.getApplicationContext().getBean(BinaryTypeConfiguration.class), (BodyBuilder)this.httpHandler.getApplicationContext().getBean(BodyBuilder.class));
            ServletExchange exchange = this.httpHandler.exchange(azureFunctionHttpRequest);
            HttpResponseMessage httpResponseMessage = (HttpResponseMessage)exchange.getResponse().getNativeResponse();
            return httpResponseMessage;
        }
        finally {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Request complete, destroying request bean {}", (Object)this);
            }
            this.applicationContext.destroyBean((Object)this);
        }
    }

    public HttpRequestMessageBuilder<?> request(HttpMethod method, String uri) {
        Objects.requireNonNull(uri, "The URI cannot be null");
        return HttpRequestMessageBuilder.builder(method, uri, this.applicationContext);
    }

    public HttpRequestMessageBuilder<?> request(io.micronaut.http.HttpMethod method, String uri) {
        Objects.requireNonNull(method, "The method cannot be null");
        return this.request(HttpMethod.value((String)method.name()), uri);
    }

    private void registerHttpHandlerShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.httpHandler = null;
        }));
    }
}

