/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.runtime.exceptions.ApplicationStartupException;
import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AzureFunction
implements ApplicationContextProvider,
Closeable {
    protected static final Logger LOG = LoggerFactory.getLogger(AzureFunction.class);
    protected static ApplicationContext applicationContext;

    protected AzureFunction() {
        if (applicationContext == null) {
            AzureFunction.startApplicationContext();
        }
        applicationContext.inject((Object)this);
    }

    private static void startApplicationContext() {
        applicationContext = ApplicationContext.builder((String[])new String[]{"azure", "function"}).deduceEnvironment(Boolean.valueOf(false)).build();
        applicationContext.start();
    }

    public ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    @Override
    public void close() throws IOException {
        if (applicationContext != null) {
            applicationContext.close();
            applicationContext = null;
        }
    }

    static {
        try {
            AzureFunction.startApplicationContext();
        }
        catch (Throwable e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Error initializing Azure function: " + e.getMessage(), e);
            }
            throw new ApplicationStartupException("Error initializing Azure function: " + e.getMessage(), e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (applicationContext != null) {
                    applicationContext.close();
                }
                applicationContext = null;
            }
        }));
    }
}

