/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.function;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.runtime.exceptions.ApplicationStartupException;
import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AzureFunction
implements ApplicationContextProvider,
Closeable {
    protected static final Logger LOG = LoggerFactory.getLogger(AzureFunction.class);
    protected static ApplicationContext applicationContext;

    protected AzureFunction() {
        this(null);
    }

    protected AzureFunction(ApplicationContextBuilder applicationContextBuilder) {
        try {
            AzureFunction.startApplicationContext(applicationContextBuilder);
        }
        catch (Throwable e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Error initializing Azure function: " + e.getMessage(), e);
            }
            throw new ApplicationStartupException("Error initializing Azure function: " + e.getMessage(), e);
        }
        this.registerApplicationContextShutDownHook();
        applicationContext.inject((Object)this);
    }

    @NonNull
    public static ApplicationContextBuilder defaultApplicationContextBuilder() {
        return ApplicationContext.builder((String[])new String[]{"azure", "function"}).deduceEnvironment(Boolean.valueOf(false));
    }

    public ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    @Override
    public void close() throws IOException {
        if (applicationContext != null) {
            applicationContext.close();
            applicationContext = null;
        }
    }

    public static void startApplicationContext(ApplicationContextBuilder applicationContextBuilder) {
        applicationContext = (applicationContextBuilder != null ? applicationContextBuilder : AzureFunction.defaultApplicationContextBuilder()).build();
        applicationContext.start();
    }

    protected void registerApplicationContextShutDownHook() {
        Runtime.getRuntime().addShutdownHook(this.createApplicationContextShutDownHook());
    }

    private Thread createApplicationContextShutDownHook() {
        return new Thread(() -> {
            if (applicationContext != null) {
                applicationContext.close();
            }
            applicationContext = null;
        });
    }
}

