/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.secretmanager;

import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import io.micronaut.azure.secretmanager.client.SecretKeyVaultClient;
import io.micronaut.azure.secretmanager.configuration.AzureKeyVaultConfigurationProperties;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.config.ConfigurationClient;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Singleton
@Requires(beans={SecretClient.class})
@BootstrapContextCompatible
public class AzureVaultConfigurationClient
implements ConfigurationClient {
    private static final Logger LOG = LoggerFactory.getLogger(AzureVaultConfigurationClient.class);
    private final AzureKeyVaultConfigurationProperties azureKeyVaultConfigurationProperties;
    private final ExecutorService executorService;
    private final SecretKeyVaultClient secretClient;
    private final String vaultUrl;

    public AzureVaultConfigurationClient(AzureKeyVaultConfigurationProperties azureKeyVaultConfigurationProperties, @Named(value="io") @Nullable ExecutorService executorService, SecretKeyVaultClient secretClient) {
        this.azureKeyVaultConfigurationProperties = azureKeyVaultConfigurationProperties;
        this.executorService = executorService;
        this.secretClient = secretClient;
        this.vaultUrl = azureKeyVaultConfigurationProperties.getVaultURL();
    }

    public Publisher<PropertySource> getPropertySources(Environment environment) {
        if (StringUtils.isEmpty((CharSequence)this.vaultUrl)) {
            return Flux.empty();
        }
        ArrayList<Flux> propertySources = new ArrayList<Flux>();
        Scheduler scheduler = this.executorService != null ? Schedulers.fromExecutor((Executor)this.executorService) : null;
        HashMap<String, String> secrets = new HashMap<String, String>();
        int retrieved = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving secrets from Azure Secret Vault with URL: {}", (Object)this.azureKeyVaultConfigurationProperties.getVaultURL());
        }
        for (KeyVaultSecret keyVaultSecret : this.secretClient.listSecrets()) {
            ++retrieved;
            secrets.put(keyVaultSecret.getName(), keyVaultSecret.getValue());
            secrets.put(keyVaultSecret.getName().replace('-', '.'), keyVaultSecret.getValue());
            secrets.put(keyVaultSecret.getName().replace('-', '_'), keyVaultSecret.getValue());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Retrieved secret: {}", (Object)keyVaultSecret.getName());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} secrets were retrieved from Azure Secret Vault with URL: {}", (Object)retrieved, (Object)this.azureKeyVaultConfigurationProperties.getVaultURL());
        }
        Flux propertySourceFlowable = Flux.just((Object)PropertySource.of(secrets));
        if (scheduler != null) {
            propertySourceFlowable = propertySourceFlowable.subscribeOn(scheduler);
        }
        propertySources.add(propertySourceFlowable);
        return Flux.merge(propertySources);
    }

    public String getDescription() {
        return "Retrieves secrets from Azure key vaults";
    }
}

