/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.secretmanager;

import com.azure.core.credential.TokenCredential;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import io.micronaut.azure.secretmanager.configuration.AzureKeyVaultConfigurationProperties;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;

@Factory
@Requirements(value={@Requires(property="micronaut.config-client.enabled", value="true", defaultValue="false"), @Requires(property="azure.key-vault")})
@BootstrapContextCompatible
public class SecretManagerFactory {
    @Singleton
    public SecretClient secretClient(@NonNull TokenCredential tokenCredential, @NonNull AzureKeyVaultConfigurationProperties azureKeyvaultConfigurationProperties) {
        return new SecretClientBuilder().vaultUrl(azureKeyvaultConfigurationProperties.getVaultURL()).credential(tokenCredential).buildClient();
    }
}

