/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.azure.secretmanager.client;

import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import io.micronaut.azure.secretmanager.client.SecretKeyVaultClient;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;

@Singleton
@BootstrapContextCompatible
@Requires(classes={SecretClient.class})
public class DefaultSecretKeyVaultClient
implements SecretKeyVaultClient {
    private final SecretClient client;

    public DefaultSecretKeyVaultClient(SecretClient client) {
        this.client = client;
    }

    @Override
    public KeyVaultSecret getSecret(String secretName) {
        return this.client.getSecret(secretName);
    }

    @Override
    public List<KeyVaultSecret> listSecrets() {
        return this.client.listPropertiesOfSecrets().stream().map(x -> this.getSecret(x.getName())).collect(Collectors.toList());
    }
}

