/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.validator;

import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.annotation.AnnotatedElementValidator;
import io.micronaut.inject.validation.BeanDefinitionValidator;
import io.micronaut.validation.validator.DefaultValidator;
import io.micronaut.validation.validator.ExecutableMethodValidator;
import io.micronaut.validation.validator.ReactiveValidator;
import io.micronaut.validation.validator.ValidatorConfiguration;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.BeanDescriptor;

@Singleton
@Primary
@Requires(property="micronaut.validator.enabled", value="true", defaultValue="true")
@Replaces(value=DefaultValidator.class)
public class MicronautHibernateValidator
extends DefaultValidator
implements io.micronaut.validation.validator.Validator,
ExecutableMethodValidator,
ReactiveValidator,
AnnotatedElementValidator,
BeanDefinitionValidator {
    private final ValidatorFactory validatorFactory;
    private final Validator validator;

    protected MicronautHibernateValidator(ValidatorFactory validatorFactory, @Nonnull ValidatorConfiguration configuration) {
        super(configuration);
        this.validatorFactory = validatorFactory;
        this.validator = validatorFactory.getValidator();
    }

    @Nonnull
    public <T> Set<ConstraintViolation<T>> validate(@Nonnull T object, Class<?> ... groups) {
        return this.validator.validate(object, (Class[])groups);
    }

    @Nonnull
    public <T> Set<ConstraintViolation<T>> validateProperty(@Nonnull T object, @Nonnull String propertyName, Class<?> ... groups) {
        return this.validator.validateProperty(object, propertyName, (Class[])groups);
    }

    @Nonnull
    public <T> Set<ConstraintViolation<T>> validateValue(@Nonnull Class<T> beanType, @Nonnull String propertyName, @Nullable Object value, Class<?> ... groups) {
        return this.validator.validateValue(beanType, propertyName, value, (Class[])groups);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.validator.getConstraintsForClass(clazz);
    }

    public <T> T unwrap(Class<T> type) {
        return (T)this.validator.unwrap(type);
    }

    @Nonnull
    public <T> Set<ConstraintViolation<T>> validateReturnValue(@Nonnull T object, @Nonnull Method method, @Nullable Object returnValue, Class<?> ... groups) {
        return this.validator.forExecutables().validateReturnValue(object, method, returnValue, (Class[])groups);
    }

    @Nonnull
    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(@Nonnull Constructor<? extends T> constructor, @Nonnull Object[] parameterValues, Class<?> ... groups) {
        return this.validator.forExecutables().validateConstructorParameters(constructor, parameterValues, (Class[])groups);
    }

    @Nonnull
    public <T> Set<ConstraintViolation<T>> validateConstructorReturnValue(@Nonnull Constructor<? extends T> constructor, @Nonnull T createdObject, Class<?> ... groups) {
        return this.validator.forExecutables().validateConstructorReturnValue(constructor, createdObject, (Class[])groups);
    }

    public <T> void validateBean(@Nonnull BeanResolutionContext resolutionContext, @Nonnull BeanDefinition<T> definition, @Nonnull T bean) throws BeanInstantiationException {
        Set violations = this.validator.validate(bean, new Class[0]);
        Class<?> beanType = bean.getClass();
        this.failOnError(resolutionContext, violations, beanType);
    }

    private <T> void failOnError(@Nonnull BeanResolutionContext resolutionContext, Set<ConstraintViolation<T>> errors, Class<?> beanType) {
        if (!errors.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Validation failed for bean definition [");
            builder.append(beanType.getName());
            builder.append("]\nList of constraint violations:[\n");
            for (ConstraintViolation<T> violation : errors) {
                builder.append("\t").append(violation.getPropertyPath()).append(" - ").append(violation.getMessage()).append("\n");
            }
            builder.append("]");
            throw new BeanInstantiationException(resolutionContext, builder.toString());
        }
    }
}

