/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.validator;

import io.micronaut.context.BeanContext;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.inject.DisposableBeanDefinition;
import jakarta.inject.Singleton;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;

@Singleton
public class DefaultConstraintValidatorFactory
implements ConstraintValidatorFactory {
    private final BeanContext beanContext;

    public DefaultConstraintValidatorFactory(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        try {
            return (T)((ConstraintValidator)this.beanContext.createBean(key));
        }
        catch (NoSuchBeanException e) {
            return (T)((ConstraintValidator)InstantiationUtils.instantiate(key));
        }
    }

    public void releaseInstance(ConstraintValidator<?, ?> instance) {
        this.beanContext.findBeanDefinition(instance.getClass()).filter(DisposableBeanDefinition.class::isInstance).ifPresent(bd -> ((DisposableBeanDefinition)bd).dispose(this.beanContext, (Object)instance));
    }
}

