/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.buffer.netty;

import io.micronaut.buffer.netty.NettyByteBuffer;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import javax.inject.Singleton;

@Internal
@Singleton
public class NettyByteBufferFactory
implements ByteBufferFactory<ByteBufAllocator, ByteBuf> {
    public static final NettyByteBufferFactory DEFAULT = new NettyByteBufferFactory();
    private final ByteBufAllocator allocator;

    public NettyByteBufferFactory() {
        this.allocator = ByteBufAllocator.DEFAULT;
    }

    public NettyByteBufferFactory(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    public ByteBufAllocator getNativeAllocator() {
        return this.allocator;
    }

    public io.micronaut.core.io.buffer.ByteBuffer<ByteBuf> buffer() {
        return new NettyByteBuffer(this.allocator.buffer());
    }

    public io.micronaut.core.io.buffer.ByteBuffer<ByteBuf> buffer(int initialCapacity) {
        return new NettyByteBuffer(this.allocator.buffer(initialCapacity));
    }

    public io.micronaut.core.io.buffer.ByteBuffer<ByteBuf> buffer(int initialCapacity, int maxCapacity) {
        return new NettyByteBuffer(this.allocator.buffer(initialCapacity, maxCapacity));
    }

    public io.micronaut.core.io.buffer.ByteBuffer<ByteBuf> copiedBuffer(byte[] bytes) {
        return new NettyByteBuffer(Unpooled.copiedBuffer((byte[])bytes));
    }

    public io.micronaut.core.io.buffer.ByteBuffer<ByteBuf> copiedBuffer(ByteBuffer nioBuffer) {
        return new NettyByteBuffer(Unpooled.copiedBuffer((ByteBuffer)nioBuffer));
    }

    public io.micronaut.core.io.buffer.ByteBuffer<ByteBuf> wrap(ByteBuf existing) {
        return new NettyByteBuffer(existing);
    }

    public io.micronaut.core.io.buffer.ByteBuffer<ByteBuf> wrap(byte[] existing) {
        return new NettyByteBuffer(Unpooled.wrappedBuffer((byte[])existing));
    }

    static {
        ConversionService.SHARED.addConverter(ByteBuf.class, io.micronaut.core.io.buffer.ByteBuffer.class, DEFAULT::wrap);
        ConversionService.SHARED.addConverter(io.micronaut.core.io.buffer.ByteBuffer.class, ByteBuf.class, byteBuffer -> {
            if (byteBuffer instanceof NettyByteBuffer) {
                return (ByteBuf)byteBuffer.asNativeBuffer();
            }
            throw new IllegalArgumentException("Unconvertible buffer type " + byteBuffer);
        });
    }
}

