/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import io.micronaut.build.MicronautBuildExtension;
import io.micronaut.build.MicronautBuildExtensionPlugin;
import java.io.File;
import java.util.ArrayList;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CheckstylePlugin;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.sonarqube.gradle.SonarExtension;
import org.sonarqube.gradle.SonarTask;

public class MicronautQualityChecksParticipantPlugin
implements Plugin<Project> {
    public static final String MICRONAUT_JACOCO_PROPERTY = "micronaut.jacoco.enabled";

    public void apply(Project project) {
        project.getPluginManager().apply(MicronautBuildExtensionPlugin.class);
        MicronautBuildExtension micronautBuild = (MicronautBuildExtension)project.getExtensions().findByType(MicronautBuildExtension.class);
        this.configureCheckstyle(project, micronautBuild);
        this.configureSonar(project);
        this.configureJacoco(project, micronautBuild);
    }

    private void configureCheckstyle(Project project, MicronautBuildExtension micronautBuildExtension) {
        project.getPluginManager().apply(CheckstylePlugin.class);
        project.afterEvaluate(p -> {
            CheckstyleExtension checkstyle = (CheckstyleExtension)p.getExtensions().findByType(CheckstyleExtension.class);
            if (checkstyle != null) {
                checkstyle.setConfigFile(p.getRootProject().getLayout().getProjectDirectory().file("config/checkstyle/checkstyle.xml").getAsFile());
                checkstyle.setToolVersion((String)micronautBuildExtension.getCheckstyleVersion().get());
                checkstyle.setMaxErrors(1);
                checkstyle.setMaxWarnings(10);
                checkstyle.setShowViolations(true);
            }
            p.getTasks().named("checkstyleTest").configure(task -> task.setEnabled(false));
            TaskProvider checkstyleMain = p.getTasks().named("checkstyleMain");
            checkstyleMain.configure(task -> p.getPluginManager().withPlugin("com.diffplug.spotless", unused -> task.dependsOn(new Object[]{"spotlessCheck"})));
            project.getTasks().withType(JavaCompile.class).configureEach(compileTask -> {
                CompileOptions options = compileTask.getOptions();
                ArrayList<String> optionsAsString = new ArrayList<String>();
                for (Object compilerArg : options.getCompilerArgs()) {
                    optionsAsString.add(compilerArg.toString());
                }
                options.setCompilerArgs(optionsAsString);
            });
            project.getRootProject().getPluginManager().withPlugin("org.sonarqube", sq -> project.getRootProject().getTasks().withType(SonarTask.class).configureEach(t -> t.dependsOn(new Object[]{checkstyleMain})));
        });
    }

    private void configureSonar(Project project) {
        if (System.getenv("SONAR_TOKEN") != null) {
            project.getRootProject().getPluginManager().withPlugin("org.sonarqube", p -> {
                SonarExtension sonarQubeExtension = (SonarExtension)project.getExtensions().findByType(SonarExtension.class);
                if (sonarQubeExtension != null) {
                    project.getPluginManager().withPlugin("checkstyle", unused -> sonarQubeExtension.properties(props -> {
                        File checkstyleReport = ((RegularFile)project.getLayout().getBuildDirectory().file("reports/checkstyle/main.xml").get()).getAsFile();
                        props.property("sonar.java.checkstyle.reportPaths", (Object)checkstyleReport.getAbsolutePath());
                    }));
                } else {
                    project.getLogger().warn("Could not find the sonarqube extension for project " + project.getName());
                }
            });
        }
    }

    private void configureJacoco(Project project, MicronautBuildExtension micronautBuild) {
        project.getPluginManager().withPlugin("java", p -> project.getPluginManager().apply(JacocoPlugin.class));
        project.afterEvaluate(unused -> project.getTasks().withType(Test.class).configureEach(t -> {
            JacocoTaskExtension jacocoTaskExtension = (JacocoTaskExtension)t.getExtensions().findByType(JacocoTaskExtension.class);
            if (jacocoTaskExtension != null) {
                ProviderFactory providers = project.getProviders();
                jacocoTaskExtension.setEnabled(((Boolean)micronautBuild.getEnvironment().isGithubAction().flatMap(isCi -> {
                    if (Boolean.TRUE.equals(isCi)) {
                        return providers.provider(() -> true);
                    }
                    return providers.gradleProperty(MICRONAUT_JACOCO_PROPERTY).orElse(providers.systemProperty(MICRONAUT_JACOCO_PROPERTY)).map(Boolean::parseBoolean);
                }).getOrElse((Object)false)).booleanValue());
            }
        }));
    }
}

