/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.aot;

import io.micronaut.build.MicronautBaseModulePlugin;
import io.micronaut.build.MicronautBuildExtension;
import io.micronaut.build.aot.MicronautBuildAotExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.plugins.ExtensionAware;

public class MicronautAotModulePlugin
implements Plugin<Project> {
    private static final String DEFAULT_AOT_VERSION = "1.0.0";

    public void apply(Project project) {
        project.getPluginManager().apply(MicronautBaseModulePlugin.class);
        MicronautBuildExtension micronautBuildExtension = (MicronautBuildExtension)project.getExtensions().getByType(MicronautBuildExtension.class);
        micronautBuildExtension.getEnableBom().set((Object)false);
        micronautBuildExtension.getEnableProcessing().set((Object)false);
        MicronautBuildAotExtension aotExtension = (MicronautBuildAotExtension)((ExtensionAware)micronautBuildExtension).getExtensions().create("aot", MicronautBuildAotExtension.class, new Object[0]);
        aotExtension.getVersion().convention((Object)DEFAULT_AOT_VERSION);
        String micronautVersion = String.valueOf(project.getProperties().get("micronautVersion"));
        DependencyHandler deps = project.getDependencies();
        deps.addProvider("compileOnlyApi", aotExtension.getVersion().map(version -> MicronautAotModulePlugin.aotModule("core", version)));
        deps.add("compileOnlyApi", (Object)MicronautAotModulePlugin.coreModule("context", micronautVersion));
        deps.add("testImplementation", (Object)MicronautAotModulePlugin.coreModule("context", micronautVersion));
        deps.addProvider("testImplementation", aotExtension.getVersion().map(version -> {
            String aot = MicronautAotModulePlugin.aotModule("core", version);
            ExternalModuleDependency dependency = (ExternalModuleDependency)deps.create((Object)aot);
            dependency.capabilities(capabilities -> capabilities.requireCapability((Object)MicronautAotModulePlugin.aotTestFixtures("core", version)));
            return dependency;
        }));
    }

    private static String aotModule(String name, String version) {
        return "io.micronaut.aot:micronaut-aot-" + name + ":" + version;
    }

    private static String aotTestFixtures(String name, String version) {
        int major = Integer.parseInt(version.split("\\.")[0]);
        String prefix = major < 2 ? "" : "micronaut-";
        return "io.micronaut.aot:" + prefix + "aot-" + name + "-test-fixtures:" + version;
    }

    private static String coreModule(String name, String version) {
        return "io.micronaut:micronaut-" + name + ":" + version;
    }
}

