/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.catalogs;

import io.micronaut.build.catalogs.tasks.VersionCatalogUpdate;
import java.util.Arrays;
import java.util.Collections;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class MicronautVersionCatalogUpdatePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        if (project != project.getRootProject()) {
            throw new IllegalStateException("The " + MicronautVersionCatalogUpdatePlugin.class.getName() + " plugin must be applied on the root project only");
        }
        TaskContainer tasks = project.getTasks();
        Directory gradleDirectory = project.getLayout().getProjectDirectory().dir("gradle");
        TaskProvider updater = tasks.register("updateVersionCatalogs", VersionCatalogUpdate.class, task -> {
            task.getCatalogsDirectory().convention(gradleDirectory);
            task.getOutputDirectory().convention(project.getLayout().getBuildDirectory().dir("catalogs-update"));
            task.getRejectedQualifiers().convention(Arrays.asList("alpha", "beta", "rc", "cr", "m", "preview", "b", "ea"));
            task.getIgnoredModules().convention(Collections.emptySet());
            task.getRejectedVersionsPerModule().convention(Collections.emptyMap());
            task.getAllowMajorUpdates().convention((Object)false);
        });
        tasks.register("useLatestVersions", Copy.class, task -> {
            VersionCatalogUpdate dependent = (VersionCatalogUpdate)((Object)((Object)updater.get()));
            task.from(new Object[]{dependent.getOutputDirectory()});
            task.into((Object)project.getProviders().environmentVariable("CI").map(value -> gradleDirectory).orElse((Provider)dependent.getCatalogsDirectory()));
        });
        tasks.register("dependencyUpdates", task -> task.setDescription("Compatibility task with the old update mechanism"));
    }
}

