/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.compat;

import io.micronaut.build.compat.BinaryCompatibibilityExtension;
import org.gradle.api.provider.Provider;

public abstract class AbstractBinaryCompatibilityExtension
implements BinaryCompatibibilityExtension {
    private final Provider<String> projectVersion;

    public AbstractBinaryCompatibilityExtension(Provider<String> projectVersion) {
        this.projectVersion = projectVersion;
    }

    @Override
    public void enabledAfter(String releaseVersion) {
        this.getEnabled().set(this.projectVersion.map(version -> {
            String[] projectVersionTokens;
            String[] tokens = releaseVersion.split("[.]");
            if (tokens.length != 3) {
                throw new IllegalArgumentException("Release version must consist of 3 parts: major.minor.bugfix but was: " + releaseVersion);
            }
            if (version.indexOf("-") > 0) {
                version = version.substring(0, version.indexOf("-"));
            }
            if ((projectVersionTokens = version.split("[.]")).length != 3) {
                throw new IllegalArgumentException("Project version must consist of 3 parts: major.minor.bugfix but was: " + version);
            }
            int projectMajor = Integer.parseInt(projectVersionTokens[0]);
            int projectMinor = Integer.parseInt(projectVersionTokens[1]);
            int projectBugfix = Integer.parseInt(projectVersionTokens[2]);
            int releaseMajor = Integer.parseInt(tokens[0]);
            int releaseMinor = Integer.parseInt(tokens[1]);
            int releaseBugfix = Integer.parseInt(tokens[2]);
            return projectMajor > releaseMajor || projectMajor == releaseMajor && projectMinor > releaseMinor || projectMajor == releaseMajor && projectMinor == releaseMinor && projectBugfix > releaseBugfix;
        }));
    }
}

