/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.compat;

public class VersionModel
implements Comparable<VersionModel> {
    private final String current;
    private final int currentAsInt;
    private final VersionModel leaf;

    public static VersionModel of(String version) {
        int idx = version.indexOf(".");
        if (idx < 0) {
            return new VersionModel(version, null);
        }
        return new VersionModel(version.substring(0, idx), VersionModel.of(version.substring(idx + 1)));
    }

    private VersionModel(String current, VersionModel leaf) {
        this.current = current;
        this.currentAsInt = VersionModel.parseInt(current);
        this.leaf = leaf;
    }

    private static int parseInt(String current) {
        try {
            return Integer.parseInt(current);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public int compareTo(VersionModel o) {
        int result = Integer.compare(this.currentAsInt, o.currentAsInt);
        if (result != 0) {
            return result;
        }
        if (this.leaf == null && o.leaf == null) {
            return 0;
        }
        if (this.leaf == null) {
            return -1;
        }
        if (o.leaf == null) {
            return 1;
        }
        return this.leaf.compareTo(o.leaf);
    }

    public String getCurrent() {
        return this.current;
    }

    public int getCurrentAsInt() {
        return this.currentAsInt;
    }

    public String getVersion() {
        if (this.leaf == null) {
            return this.current;
        }
        return this.current + "." + this.leaf;
    }

    public String toString() {
        return this.getVersion();
    }
}

