/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.docs.props;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class ReplaceAtLinkTask
extends DefaultTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getInputFiles();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @TaskAction
    public void execute() throws IOException {
        File outputFile = (File)this.getOutputFile().getAsFile().get();
        if (outputFile.getParentFile().isDirectory() || outputFile.getParentFile().mkdirs()) {
            for (File configPropertiesFile : this.getInputFiles().getFiles()) {
                if (!configPropertiesFile.exists()) continue;
                List<String> lines = Files.readAllLines(configPropertiesFile.toPath(), StandardCharsets.UTF_8);
                try (PrintWriter prn = new PrintWriter(outputFile, StandardCharsets.UTF_8.name());){
                    Iterator<String> iterator = lines.iterator();
                    while (iterator.hasNext()) {
                        String line;
                        String processedLine = line = iterator.next();
                        while (processedLine.contains("{@link io.micronaut.")) {
                            processedLine = ReplaceAtLinkTask.atLinkReplacer(processedLine);
                        }
                        prn.print(processedLine + "\n");
                    }
                }
            }
        }
    }

    private static String atLinkReplacer(String str) {
        Object newLine = str.substring(0, str.indexOf("{@link io.micronaut."));
        String sub = "api:" + str.substring(str.indexOf("{@link io.micronaut.") + "{@link io.micronaut.".length());
        newLine = (String)newLine + sub.substring(0, sub.indexOf(125)) + "[]";
        newLine = (String)newLine + sub.substring(sub.indexOf(125) + "}".length());
        return newLine;
    }
}

