/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.pom;

import io.micronaut.build.pom.BomSuppressions;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Nested;

public interface MicronautBomExtension {
    public Property<String> getCatalogName();

    public Property<Spec<? super Project>> getExcludeProject();

    public SetProperty<String> getExtraExcludedProjects();

    public Property<Boolean> getPublishCatalog();

    public Property<Boolean> getImportProjectCatalog();

    public Property<Boolean> getIncludeBomInCatalog();

    public MapProperty<String, String> getCatalogToPropertyNameOverrides();

    public Property<Boolean> getInlineNestedCatalogs();

    public Property<Boolean> getInlineRegularBOMs();

    public SetProperty<String> getExcludedInlinedAliases();

    public MapProperty<String, Set<String>> getExcludeFromInlining();

    public MapProperty<String, Set<String>> getInlinedAliases();

    public Property<String> getPropertyName();

    public Property<Boolean> getInferProjectsToInclude();

    public MapProperty<String, String> getInferredManagedDependencies();

    default public void inferredManagedDependencies(List<String> dependencies) {
        this.getInferredManagedDependencies().putAll(dependencies.stream().collect(Collectors.toMap(d -> d, d -> d.substring(d.indexOf(":") + 1))));
    }

    @Nested
    public BomSuppressions getSuppressions();

    default public void suppressions(Action<? super BomSuppressions> spec) {
        spec.execute((Object)this.getSuppressions());
    }

    default public void excludeFromInlining(String alias, String ... dependencies) {
        this.getExcludeFromInlining().put((Object)alias, Set.of(dependencies));
    }

    default public void excludeFromInlining(String alias, Set<String> dependencies) {
        this.getExcludeFromInlining().put((Object)alias, dependencies);
    }
}

