/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.pom;

import io.micronaut.build.pom.PomDependency;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;

public class PomDownloader {
    private static Pattern SNAPSHOT_PATTERN = Pattern.compile("<snapshot>.*</snapshot>");
    private static Pattern ID_PATTERN = Pattern.compile("<timestamp>(.*?)</timestamp><buildNumber>(.*?)</buildNumber>");
    private final List<String> repositories;
    private final File pomsDirectory;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Set<String> processing = new HashSet<String>();

    public PomDownloader(List<String> repositories, File pomDirectory) {
        this.repositories = repositories;
        this.pomsDirectory = pomDirectory;
    }

    public Optional<File> tryDownloadPom(PomDependency dependency) {
        return this.repositories.stream().map(repositoryUrl -> this.tryDownloadPom(dependency, (String)repositoryUrl)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<File> tryDownloadPom(PomDependency dependency, String repositoryUrl) {
        Optional<String> snapshotVersion;
        if (repositoryUrl.endsWith("/")) {
            repositoryUrl = repositoryUrl.substring(0, repositoryUrl.length() - 1);
        }
        String group = dependency.getGroupId();
        String artifact = dependency.getArtifactId();
        Object version = dependency.getVersion();
        String basedir = "/" + group.replace('.', '/') + "/" + artifact + "/" + (String)version + "/";
        boolean isSnapshot = ((String)version).endsWith("-SNAPSHOT");
        if (isSnapshot && (snapshotVersion = this.findSnapshotVersion(repositoryUrl, basedir)).isPresent()) {
            version = ((String)version).substring(0, ((String)version).indexOf("-SNAPSHOT")) + "-" + snapshotVersion.get();
        }
        String pomFilePath = basedir + artifact + "-" + (String)version + ".pom";
        String uri = repositoryUrl + pomFilePath;
        this.lock.lock();
        try {
            while (this.processing.contains(pomFilePath)) {
                this.condition.await();
            }
            this.processing.add(pomFilePath);
        }
        catch (InterruptedException e) {
            throw new GradleException("Unable to download POM at " + uri, (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
        try {
            URL url = new URL(uri);
            File pomFile = new File(this.pomsDirectory, pomFilePath);
            if (pomFile.exists() && isSnapshot) {
                pomFile.delete();
            }
            if (!pomFile.exists()) {
                try (InputStream in = url.openStream();){
                    pomFile.getParentFile().mkdirs();
                    Files.copy(in, pomFile.toPath(), new CopyOption[0]);
                }
            }
            Optional<File> optional = Optional.of(pomFile);
            return optional;
        }
        catch (IOException e) {
            Optional<File> optional = Optional.empty();
            return optional;
        }
        finally {
            this.lock.lock();
            try {
                this.processing.remove(pomFilePath);
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> findSnapshotVersion(String repositoryUrl, String basedir) {
        String uri = repositoryUrl + basedir + "maven-metadata.xml";
        try {
            URL url = new URL(uri);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                String text = sb.toString().replaceAll("[\\r\\n\\t ]", "");
                Matcher matcher = SNAPSHOT_PATTERN.matcher(text);
                if (!matcher.find()) return Optional.empty();
                text = matcher.group();
                if (!(matcher = ID_PATTERN.matcher(text)).find()) return Optional.empty();
                Optional<CallSite> optional = Optional.of(matcher.group(1) + "-" + matcher.group(2));
                return optional;
            }
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

