/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;

public abstract class ExternalURLService
implements BuildService<BuildServiceParameters.None> {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Set<String> currentHosts = new HashSet<String>();
    private final Map<URI, byte[]> responses = new ConcurrentHashMap<URI, byte[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<byte[]> fetchFromURL(URI uri) {
        this.lock.lock();
        String host = uri.getHost();
        try {
            while (this.currentHosts.contains(host)) {
                this.condition.await();
            }
            this.currentHosts.add(host);
        }
        catch (InterruptedException e) {
            throw new GradleException("Unable to fetch external resource at " + uri, (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
        try {
            Optional<byte[]> optional = Optional.ofNullable(this.responses.computeIfAbsent(uri, ExternalURLService::doDownload));
            return optional;
        }
        finally {
            this.lock.lock();
            try {
                this.currentHosts.remove(host);
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static byte[] doDownload(URI uri) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (InputStream stream = uri.toURL().openStream();){
            int read;
            byte[] buffer = new byte[4096];
            while ((read = stream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            return null;
        }
        return outputStream.toByteArray();
    }

    public static Provider<ExternalURLService> registerOn(Project project) {
        return project.getGradle().getSharedServices().registerIfAbsent("ExternalURLService", ExternalURLService.class, spec -> {});
    }
}

