/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.utils;

import io.micronaut.build.utils.BasicAuthUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;

public final class GithubApiUtils {
    private static final String GH_TOKEN_PUBLIC_REPOS_READONLY = "GH_TOKEN_PUBLIC_REPOS_READONLY";
    private static final String GH_USERNAME = "GH_USERNAME";
    public static final String GITHUB_API_BASE_URL_SYSTEM_PROPERTY = "github.api.base.url";
    public static final String GITHUB_BASE_API_URL = "https://api.github.com";

    private GithubApiUtils() {
    }

    static byte[] fetchTagsFromGitHub(Logger logger, String slug) {
        return GithubApiUtils.fetchFromGithub(logger, slug, "tags");
    }

    private static byte[] fetchFromGithub(Logger logger, String slug, String what) {
        String url = System.getProperty(GITHUB_API_BASE_URL_SYSTEM_PROPERTY, GITHUB_BASE_API_URL) + "/repos/" + GithubApiUtils.normalizeSlug(slug) + "/" + what;
        logger.lifecycle("Fetching " + what + " from " + url);
        try {
            return GithubApiUtils.fetchFromGithub(logger, GithubApiUtils.connectionForGithubUrl(logger, url));
        }
        catch (IOException ex) {
            throw new GradleException("Failed to read " + what + " from " + url, (Throwable)ex);
        }
    }

    private static byte[] fetchFromGithub(Logger logger, HttpURLConnection con) throws IOException {
        byte[] byArray;
        block8: {
            InputStream in = con.getInputStream();
            try {
                byArray = GithubApiUtils.readFromStream(in).toByteArray();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    ByteArrayOutputStream errorOut = GithubApiUtils.readFromStream(con.getErrorStream());
                    logger.error("Failed to read from Github API. Response code: " + con.getResponseCode() + "\nResponse message: " + con.getResponseMessage() + "\nError body: " + errorOut + "\nResponse headers: " + con.getHeaderFields());
                    throw ex;
                }
            }
            in.close();
        }
        return byArray;
    }

    private static ByteArrayOutputStream readFromStream(InputStream in) throws IOException {
        ByteArrayOutputStream errorOut = new ByteArrayOutputStream();
        try (ReadableByteChannel rbc = Channels.newChannel(in);
             WritableByteChannel wbc = Channels.newChannel(errorOut);){
            ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
            while (rbc.read(buffer) != -1) {
                buffer.flip();
                wbc.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                wbc.write(buffer);
            }
        }
        return errorOut;
    }

    private static HttpURLConnection connectionForGithubUrl(Logger logger, String githubUrl) throws IOException {
        URL url = new URL(githubUrl);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        if (System.getenv("CI") != null) {
            con.setRequestProperty("User-Agent", "Micronaut-Framework-Ci");
        }
        con.setRequestProperty("Accept", "application/vnd.github.v3+json");
        if (System.getenv(GH_TOKEN_PUBLIC_REPOS_READONLY) != null || System.getenv(GH_USERNAME) != null) {
            con.setRequestProperty("Authorization", BasicAuthUtils.basicAuth(System.getenv(GH_USERNAME), System.getenv(GH_TOKEN_PUBLIC_REPOS_READONLY)));
        } else if (logger != null) {
            if (System.getenv(GH_USERNAME) == null) {
                logger.warn("Environment variable GH_USERNAME not defined");
            }
            if (System.getenv(GH_TOKEN_PUBLIC_REPOS_READONLY) == null) {
                logger.warn("Environment variable GH_TOKEN_PUBLIC_REPOS_READONLY not defined");
            }
        }
        return con;
    }

    private static String normalizeSlug(String slug) {
        if (slug.startsWith("/")) {
            slug = slug.substring(1);
        }
        if (slug.endsWith("/")) {
            slug = slug.substring(0, slug.length() - 1);
        }
        return slug;
    }
}

