/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.docs.converter;

import io.micronaut.docs.converter.ModelVisitor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractModelVisitor
implements ModelVisitor {
    private final Map<String, Object> model;
    private final StringBuilder sb = new StringBuilder();

    public AbstractModelVisitor(Map<String, Object> model) {
        this.model = model;
    }

    @Override
    public void visitMap(ModelVisitor.Context context, Map<String, Object> map) {
        this.preVisitMap(context, map);
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String childKey = entry.getKey();
            Object value = entry.getValue();
            ModelVisitor.Context child = context.child(childKey, ModelVisitor.NodeKind.MAP);
            boolean isLast = !iterator.hasNext();
            this.preVisitMapEntry(child, childKey, value, isLast);
            this.visitMapEntry(child, childKey, value, isLast);
            this.postVisitMapEntry(child, childKey, value, isLast);
        }
        this.postVisitMap(context, map);
    }

    @Override
    public void visitList(ModelVisitor.Context context, List<Object> list) {
        this.preVisitList(context, list);
        for (int i = 0; i < list.size(); ++i) {
            boolean isLastItem = i == list.size() - 1;
            Object o = list.get(i);
            String childKey = "[" + i + "]";
            ModelVisitor.Context child = context.child(childKey, ModelVisitor.NodeKind.LIST);
            this.preVisitListItem(child, o, isLastItem);
            this.visitListItem(child, o, isLastItem);
            this.postVisitListItem(child, o, isLastItem);
        }
        this.postVisitList(context, list);
    }

    @Override
    public void visitString(ModelVisitor.Context context, String value) {
        this.visitObject(context, value);
    }

    @Override
    public void visitNumber(ModelVisitor.Context context, Number value) {
        this.visitObject(context, value);
    }

    @Override
    public void visit(ModelVisitor.Context context, Object object) {
        switch (ModelVisitor.kindOf(object)) {
            case MAP: {
                this.visitMap(context, (Map)object);
                break;
            }
            case LIST: {
                this.visitList(context, (List)object);
                break;
            }
            case STRING: {
                this.visitString(context, (String)object);
                break;
            }
            case NUMBER: {
                this.visitNumber(context, (Number)object);
                break;
            }
            case OBJECT: {
                this.visitObject(context, object);
            }
        }
    }

    public void visit() {
        this.visitMap(new ModelVisitor.Context(null, "", ModelVisitor.NodeKind.OBJECT), this.model);
    }

    public String toString() {
        return this.sb.toString();
    }

    public StringBuilder append(Object obj) {
        return this.sb.append(obj);
    }

    public StringBuilder append(String str) {
        return this.sb.append(str);
    }

    public StringBuilder append(StringBuffer sb) {
        return this.sb.append(sb);
    }

    public StringBuilder append(CharSequence s) {
        return this.sb.append(s);
    }

    public StringBuilder append(boolean b) {
        return this.sb.append(b);
    }

    public StringBuilder append(char c) {
        return this.sb.append(c);
    }

    public StringBuilder append(int i) {
        return this.sb.append(i);
    }

    public StringBuilder append(long lng) {
        return this.sb.append(lng);
    }

    public StringBuilder append(float f) {
        return this.sb.append(f);
    }

    public StringBuilder append(double d) {
        return this.sb.append(d);
    }

    public boolean isEmpty() {
        return this.sb.length() == 0;
    }
}

