/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.docs.converter;

import io.micronaut.docs.converter.AbstractModelVisitor;
import io.micronaut.docs.converter.ModelVisitor;
import java.util.List;
import java.util.Map;

public class HoconGenerator
extends AbstractModelVisitor {
    private static final String INDENT = "  ";

    public HoconGenerator(Map<String, Object> model) {
        super(model);
    }

    private void indent(ModelVisitor.Context context) {
        for (int i = 0; i < context.depth(); ++i) {
            this.append(INDENT);
        }
    }

    @Override
    public void preVisitMap(ModelVisitor.Context context, Map<String, Object> map) {
        this.append("{").append("\n");
    }

    @Override
    public void postVisitMap(ModelVisitor.Context context, Map<String, Object> map) {
        this.indent(context);
        this.append("}");
    }

    @Override
    public void visitMapEntry(ModelVisitor.Context context, String entryKey, Object entryValue, boolean isLast) {
        boolean addQuotes;
        this.indent(context);
        String escaped = HoconGenerator.escape(entryKey).toString();
        boolean bl = addQuotes = !escaped.equals(entryKey) || entryKey.contains(".");
        if (addQuotes) {
            this.append("\"");
        }
        this.append(escaped);
        if (addQuotes) {
            this.append("\"");
        }
        if (ModelVisitor.kindOf(entryValue) == ModelVisitor.NodeKind.MAP) {
            this.append(" ");
        } else {
            this.append(" = ");
        }
        this.visit(context, entryValue);
    }

    @Override
    public void postVisitMapEntry(ModelVisitor.Context context, String entryKey, Object entryValue, boolean isLast) {
        this.append("\n");
    }

    @Override
    public void preVisitMapEntry(ModelVisitor.Context context, String entryKey, Object entryValue, boolean isLast) {
    }

    @Override
    public void preVisitList(ModelVisitor.Context context, List<Object> list) {
        this.append("[");
    }

    @Override
    public void postVisitList(ModelVisitor.Context context, List<Object> list) {
        this.append("]");
    }

    @Override
    public void preVisitListItem(ModelVisitor.Context context, Object item, boolean isLastItem) {
    }

    @Override
    public void postVisitListItem(ModelVisitor.Context context, Object item, boolean isLastItem) {
        if (!isLastItem) {
            this.append(", ");
        }
    }

    @Override
    public void visitListItem(ModelVisitor.Context context, Object item, boolean isLastItem) {
        this.visit(context, item);
    }

    @Override
    public void visitObject(ModelVisitor.Context context, Object object) {
        this.append(object);
    }

    @Override
    public void visitString(ModelVisitor.Context context, String value) {
        this.append("\"").append((CharSequence)HoconGenerator.escape(value)).append("\"");
    }

    private static StringBuilder escape(String text) {
        StringBuilder out = new StringBuilder(text.length());
        block7: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\"') {
                out.append("\\\"");
                continue;
            }
            if (ch == '\\') {
                out.append("\\\\");
                continue;
            }
            if (ch >= ' ') {
                out.append(ch);
                continue;
            }
            switch (ch) {
                case '\t': {
                    out.append("\\t");
                    continue block7;
                }
                case '\b': {
                    out.append("\\b");
                    continue block7;
                }
                case '\n': {
                    out.append("\\n");
                    continue block7;
                }
                case '\r': {
                    out.append("\\r");
                    continue block7;
                }
                case '\f': {
                    out.append("\\f");
                    continue block7;
                }
                default: {
                    out.append("\\u").append(String.format("%04x", text.codePointAt(i)));
                }
            }
        }
        return out;
    }
}

