/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import io.micronaut.build.BuildEnvironment;
import io.micronaut.build.MicronautCompileOptions;
import io.micronaut.build.pom.BomSuppressions;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Nested;

public abstract class MicronautBuildExtension {
    public static final String DEFAULT_DEPENDENCY_UPDATES_PATTERN = "(?i).+(-|\\.?)(b|M|RC|Dev)\\d?.*";
    public static final int DEFAULT_JAVA_VERSION = 17;
    public static final String DEFAULT_CHECKSTYLE_VERSION = "10.5.0";
    private final BuildEnvironment environment;
    private final MicronautCompileOptions compileOptions;
    private Closure<?> resolutionStrategy;

    @Inject
    public abstract ObjectFactory getObjects();

    @Inject
    public MicronautBuildExtension(BuildEnvironment buildEnvironment) {
        this.environment = buildEnvironment;
        this.compileOptions = (MicronautCompileOptions)this.getObjects().newInstance(MicronautCompileOptions.class, new Object[0]);
        this.getJavaVersion().convention((Object)17);
        this.getTestJavaVersion().convention((Object)Integer.valueOf(JavaVersion.current().getMajorVersion()));
        this.getCheckstyleVersion().convention((Object)DEFAULT_CHECKSTYLE_VERSION);
        this.getDependencyUpdatesPattern().convention((Object)DEFAULT_DEPENDENCY_UPDATES_PATTERN);
        this.getEnforcedPlatform().convention((Object)false);
        this.getEnableProcessing().convention((Object)false);
        this.getEnableBom().convention((Object)true);
    }

    public BuildEnvironment getEnvironment() {
        return this.environment;
    }

    public MicronautCompileOptions getCompileOptions() {
        return this.compileOptions;
    }

    public Closure<?> getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    public abstract Property<Integer> getJavaVersion();

    public abstract Property<Integer> getTestJavaVersion();

    @Deprecated
    public abstract Property<String> getSourceCompatibility();

    @Deprecated
    public abstract Property<String> getTargetCompatibility();

    public abstract Property<String> getCheckstyleVersion();

    public abstract Property<String> getDependencyUpdatesPattern();

    public abstract Property<Boolean> getEnforcedPlatform();

    public abstract Property<Boolean> getEnableProcessing();

    public abstract Property<Boolean> getEnableBom();

    @Nested
    public abstract BomSuppressions getBomSuppressions();

    void bomSuppressions(Action<? super BomSuppressions> spec) {
        spec.execute((Object)this.getBomSuppressions());
    }

    public void resolutionStrategy(@DelegatesTo(value=ResolutionStrategy.class) Closure<?> closure) {
        this.resolutionStrategy = closure;
    }
}

