/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import com.gradle.CommonCustomUserDataGradlePlugin;
import com.gradle.develocity.agent.gradle.DevelocityConfiguration;
import com.gradle.develocity.agent.gradle.DevelocityPlugin;
import io.micronaut.build.BuildEnvironment;
import io.micronaut.build.MicronautBuildSettingsExtension;
import io.micronaut.build.MicronautBuildSettingsPlugin;
import io.micronaut.build.utils.ProviderUtils;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.caching.configuration.BuildCacheConfiguration;
import org.nosphere.gradle.github.ActionsPlugin;

public class MicronautDevelocityPlugin
implements Plugin<Settings> {
    private static final String[] SAFE_TO_LOG_ENV_VARIABLES = new String[]{"PREDICTIVE_TEST_SELECTION"};

    public void apply(Settings settings) {
        PluginManager pluginManager = settings.getPluginManager();
        pluginManager.apply(MicronautBuildSettingsPlugin.class);
        if (!MicronautDevelocityPlugin.isDevelocityEnabled(settings)) {
            return;
        }
        pluginManager.apply(DevelocityPlugin.class);
        pluginManager.apply(CommonCustomUserDataGradlePlugin.class);
        Provider projectGroup = settings.getProviders().gradleProperty("projectGroup");
        if (projectGroup.isPresent() && !((String)projectGroup.get()).startsWith("io.micronaut")) {
            return;
        }
        DevelocityConfiguration config = (DevelocityConfiguration)settings.getExtensions().getByType(DevelocityConfiguration.class);
        MicronautBuildSettingsExtension micronautBuildSettingsExtension = (MicronautBuildSettingsExtension)settings.getExtensions().getByType(MicronautBuildSettingsExtension.class);
        this.configureDevelocity(settings, config, micronautBuildSettingsExtension);
    }

    private static boolean isDevelocityEnabled(Settings settings) {
        return MicronautDevelocityPlugin.booleanProperty(settings, "develocity.enabled", true);
    }

    private static boolean booleanProperty(Settings settings, String name, boolean defaultValue) {
        return (Boolean)settings.getProviders().gradleProperty(name).map(Boolean::parseBoolean).getOrElse((Object)defaultValue);
    }

    private void configureDevelocity(Settings settings, DevelocityConfiguration config, MicronautBuildSettingsExtension micronautBuildSettingsExtension) {
        BuildEnvironment buildEnvironment;
        ProviderFactory providers = settings.getProviders();
        boolean publishScanOnDemand = MicronautDevelocityPlugin.booleanProperty(settings, "publishScanOnDemand", false);
        boolean isCI = ProviderUtils.guessCI(providers);
        boolean buildScanExplicit = settings.getStartParameter().isBuildScan();
        this.configureBuildScansPublishing(config, isCI, publishScanOnDemand, buildScanExplicit);
        settings.getGradle().projectsLoaded(MicronautDevelocityPlugin::applyGitHubActionsPlugin);
        this.tagWithJavaDetails(config, providers);
        if (MicronautDevelocityPlugin.booleanProperty(settings, "org.gradle.caching", true)) {
            MicronautDevelocityPlugin.configureBuildCache(settings, config, micronautBuildSettingsExtension, providers, isCI);
        }
        if (Boolean.TRUE.equals((buildEnvironment = new BuildEnvironment(providers)).isTestSelectionEnabled().get())) {
            config.getBuildScan().tag("Predictive Test Selection");
        }
        this.captureSafeEnvironmentVariables(config);
    }

    private static void configureBuildCache(Settings settings, DevelocityConfiguration config, MicronautBuildSettingsExtension micronautBuildSettingsExtension, ProviderFactory providers, boolean isCI) {
        settings.getGradle().settingsEvaluated(lateSettings -> {
            BuildCacheConfiguration buildCache = settings.getBuildCache();
            boolean localEnabled = (Boolean)micronautBuildSettingsExtension.getUseLocalCache().get();
            boolean remoteEnabled = (Boolean)micronautBuildSettingsExtension.getUseRemoteCache().get();
            boolean push = (Boolean)MicronautBuildSettingsExtension.booleanProvider(providers, "cachePush", isCI).get();
            if (isCI) {
                System.out.println("Build cache     enabled     push");
                System.out.println("    Local        " + (localEnabled ? "   Y   " : "   N   ") + "     N/A");
                System.out.println("    Remote       " + (remoteEnabled ? "   Y   " : "   N   ") + "     " + (push ? " Y" : " N"));
            }
            buildCache.getLocal().setEnabled(localEnabled);
            if (remoteEnabled) {
                MicronautDevelocityPlugin.configureRemoteCache(config, buildCache, push, providers);
            }
        });
    }

    private static void configureRemoteCache(DevelocityConfiguration config, BuildCacheConfiguration buildCache, boolean push, ProviderFactory providers) {
        buildCache.remote(config.getBuildCache(), remote -> {
            remote.setEnabled(true);
            if (push) {
                String accessKey = (String)providers.environmentVariable("GRADLE_ENTERPRISE_ACCESS_KEY").orElse(providers.environmentVariable("DEVELOCITY_ACCESS_KEY")).orElse(providers.systemProperty("GRADLE_ENTERPRISE_ACCESS_KEY")).getOrNull();
                if (accessKey != null && !accessKey.isEmpty()) {
                    remote.setPush(true);
                } else {
                    System.err.println("WARNING: Access key missing for remote build cache, cannot configure push!");
                }
            }
        });
    }

    private void tagWithJavaDetails(DevelocityConfiguration ge, ProviderFactory providers) {
        Provider vendor = providers.systemProperty("java.vendor");
        if (vendor.isPresent()) {
            ge.getBuildScan().tag("vendor:" + ((String)vendor.get()).toLowerCase().replaceAll("\\W+", "_"));
        }
        ge.getBuildScan().tag("jdk:" + JavaVersion.current().getMajorVersion());
    }

    private void captureSafeEnvironmentVariables(DevelocityConfiguration ge) {
        for (String variable : SAFE_TO_LOG_ENV_VARIABLES) {
            String value = System.getenv(variable);
            ge.getBuildScan().value("env." + variable, value == null ? "<undefined>" : value);
        }
    }

    private void configureBuildScansPublishing(DevelocityConfiguration config, boolean isCI, boolean publishScanOnDemand, boolean buildScanExplicit) {
        config.getServer().convention((Object)"https://ge.micronaut.io");
        config.buildScan(buildScan -> buildScan.getPublishing().onlyIf(context -> {
            if (publishScanOnDemand) {
                return buildScanExplicit;
            }
            return isCI || context.isAuthenticated();
        }));
    }

    private static void applyGitHubActionsPlugin(Gradle gradle) {
        gradle.getRootProject().getPluginManager().apply(ActionsPlugin.class);
    }
}

