/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import java.io.File;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;

class SimpleMavenModelResolver
implements ModelResolver {
    private final ConfigurationContainer configurations;
    private final DependencyHandler dependencies;

    SimpleMavenModelResolver(ConfigurationContainer configurations, DependencyHandler dependencies) {
        this.configurations = configurations;
        this.dependencies = dependencies;
    }

    private File resolvePomFile(String groupId, String artifactId, String version, String classifier) {
        Configuration conf = this.configurations.detachedConfiguration(new org.gradle.api.artifacts.Dependency[0]);
        Object classy = classifier == null ? "" : ":" + classifier;
        conf.getDependencies().add((Object)this.dependencies.create((Object)(groupId + ":" + artifactId + ":" + version + (String)classy + "@pom")));
        return conf.getSingleFile();
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        return new FileModelSource(this.resolvePomFile(groupId, artifactId, version, null));
    }

    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        return new FileModelSource(this.resolvePomFile(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier()));
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
    }

    public void addRepository(Repository repository, boolean b) throws InvalidRepositoryException {
    }

    public ModelResolver newCopy() {
        return this;
    }
}

