/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.catalogs.internal;

import io.micronaut.build.catalogs.internal.VersionModel;
import org.tomlj.TomlPosition;

public class Library {
    private final String alias;
    private final String group;
    private final String name;
    private final VersionModel version;
    private final TomlPosition position;

    public Library(String alias, String group, String name, VersionModel version, TomlPosition position) {
        this.alias = alias;
        this.group = group;
        this.name = name;
        this.version = version;
        this.position = position;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getModule() {
        return this.group + ":" + this.name;
    }

    public VersionModel getVersion() {
        return this.version;
    }

    public TomlPosition getPosition() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Library library = (Library)o;
        if (!this.group.equals(library.group)) {
            return false;
        }
        if (!this.name.equals(library.name)) {
            return false;
        }
        return this.version.equals(library.version);
    }

    public int hashCode() {
        int result = this.group.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }
}

