/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.compat;

import io.micronaut.build.compat.MavenMetadataVersionHelper;
import io.micronaut.build.utils.ComparableVersion;
import io.micronaut.build.utils.ExternalURLService;
import io.micronaut.build.utils.VersionParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class FindBaselineTask
extends DefaultTask {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int CACHE_IN_SECONDS = 3600;

    @Input
    public abstract Property<String> getBaseRepository();

    @Input
    public abstract Property<String> getGroupId();

    @Input
    public abstract Property<String> getArtifactId();

    @Input
    public abstract Property<String> getCurrentVersion();

    @Input
    protected Provider<Long> getTimestamp() {
        return this.getProviders().provider(() -> {
            long seconds = System.currentTimeMillis() / 1000L;
            long base = seconds / 3600L;
            return base * 3600L;
        });
    }

    @Internal
    protected Provider<byte[]> getMavenMetadata() {
        Provider artifactPath = this.getGroupId().zip(this.getArtifactId(), (groupId, artifactId) -> groupId.replace('.', '/') + "/" + artifactId + "/maven-metadata.xml");
        return this.getBaseRepository().zip(artifactPath, (baseUrl, path) -> {
            String url = baseUrl + "/" + path;
            try {
                return ((ExternalURLService)this.getDownloader().get()).fetchFromURL(new URI(url)).orElse(EMPTY_BYTE_ARRAY);
            }
            catch (URISyntaxException e) {
                throw new GradleException("Invalid URI: " + url, (Throwable)e);
            }
        });
    }

    @Internal
    abstract Property<ExternalURLService> getDownloader();

    @Inject
    protected abstract ProviderFactory getProviders();

    @OutputFile
    public abstract RegularFileProperty getPreviousVersion();

    @TaskAction
    public void execute() throws IOException {
        byte[] metadata = (byte[])this.getMavenMetadata().get();
        List<ComparableVersion> releases = MavenMetadataVersionHelper.findReleasesFrom(metadata);
        ComparableVersion current = VersionParser.parse(this.trimVersion());
        Optional<ComparableVersion> previous = MavenMetadataVersionHelper.findPreviousReleaseFor(current, releases);
        if (!previous.isPresent()) {
            throw new IllegalStateException("Could not find a previous version for " + current);
        }
        Files.write(((RegularFile)this.getPreviousVersion().get()).getAsFile().toPath(), previous.get().toString().getBytes("UTF-8"), new OpenOption[0]);
    }

    private String trimVersion() {
        String version = (String)this.getCurrentVersion().get();
        int idx = version.indexOf(45);
        if (idx >= 0) {
            return version.substring(0, idx);
        }
        return version;
    }
}

